/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <stdio.h>
#include <vfreebusy.h>
#include <miscfunctions.h>

#define IDSTRING "VFreeBusy: "

extern Toolbox tb;

void VFreeBusy::parseFreeBusyLine(MetaLine *line)
{
	QString type=(*(line->getQuality()))["FBTYPE"].content()[0];
#ifdef DEBUG_VFREEBUSY
	printf(IDSTRING"The line's type is: <%s>\n",(const char *)type);
	printf(IDSTRING"The line's content is: <%s>\n",
			(const char *)line->getContent());
#endif
	QStringList items=enhancedSplit(line->getContent(),',',QStringList());
	QValueList<Period> result;
	// generating the list of free/busy periods
	for(int i=0;i<items.count();i++)
	{
		result.append(tb.parseString(items[i]));
	}
	// copying (append) the "result" into the appropriate list
	if(type.find("FREE",0,false)==0)
	{
#ifdef DEBUG_VFREEBUSY
		printf(IDSTRING"adding stuff to free\n");
#endif
		free+=result;
	}
	else if(type.find("BUSY-UNAVAILABLE",0,false)==0)
	{
#ifdef DEBUG_VFREEBUSY
		printf(IDSTRING"adding stuff to busyUnavailable\n");
#endif
		busyUnavailable+=result;
	}
	else if(type.find("TENTATIVE",0,false)==0)
	{
#ifdef DEBUG_VFREEBUSY
		printf(IDSTRING"adding stuff to busy-tentative\n");
#endif
		busyTentative+=result;
	}
	else
	{
#ifdef DEBUG_VFREEBUSY
		printf(IDSTRING"adding stuff to busy(2)\n");
#endif
		busy+=result;
	}
}


QValueList<Period> VFreeBusy::getFreeBusy(VFreeBusy::PeriodsType type)
{
	switch(type)
	{
		case VFreeBusy::Free: return free;
		case VFreeBusy::Busy: return busy;
		case VFreeBusy::Unavailable: return busyUnavailable;
		case VFreeBusy::Tentative: return busyTentative;
	}
	printf(IDSTRING"ERROR: Invalid query for free/busy type. "
		"Returning void list.\n");
	return QValueList<Period>();
}


void VFreeBusy::parseAttendees()
{
	QValueList<int> matches;
	matches=mObj->query("attendee");
	for(int i=0;i<matches.count();i++)
	{
		attendees.append(mObj->getLines().at(matches[i])->getContent());
#ifdef DEBUG_VFREEBUSY
		printf(IDSTRING"Attendee: <%s>\n",
			(const char *)attendees[i]);
#endif
	} //for
}

void VFreeBusy::parseOrganizer()
{
	QValueList<int> matches;
	matches=mObj->query("organizer");
	organizer=mObj->getLines().at(matches[0])->getContent();
}
void VFreeBusy::parseDT()
{
	QValueList<int> matches;
	matches=mObj->query("dtstart");
	Toolbox::TimeZone tz;
	dtStart=tb.getDateTime(mObj->getLines().at(matches[0])->getContent(),tz);
	matches=mObj->query("dtend");
	dtEnd=tb.getDateTime(mObj->getLines().at(matches[0])->getContent(),tz);
	matches=mObj->query("dtstamp");
	dtStamp=tb.getDateTime(mObj->getLines().at(matches[0])->getContent(),tz);
}

void VFreeBusy::parseID()
{
	QValueList<int> matches;
	matches=mObj->query("uid");
	id=mObj->getLines().at(matches[0])->getContent();
}
void VFreeBusy::parseDuration()
{
	Toolbox::IntervalType it;
	QValueList<int> matches;
	matches=mObj->query("duration");
	duration=tb.getDateTimeOffset(mObj->getLines().at(matches[0])->getContent(),
		it);
}
void VFreeBusy::parseURL()
{
	QValueList<int> matches;
	matches=mObj->query("URL");
	url=mObj->getLines().at(matches[0])->getContent();
}
void VFreeBusy::parseRequestStatus()
{
	QValueList<int> matches;
	matches=mObj->query("request-status");
	requestStatus=mObj->getLines().at(matches[0])->getContent();
}

VFreeBusy::VFreeBusy(MetaObject *mo, Toolbox::Method method)
{
	mObj=mo;
	
	QValueList<int> matches;
	free.clear(); busy.clear(); busyUnavailable.clear(); busyTentative.clear();
	matches=mObj->query("freebusy");
	for(int i=0;i<matches.count();i++)
	{
#ifdef DEBUG_VFREEBUSY
		printf(IDSTRING" <%s>\n",
			(const char *)mObj->getLines().at(matches[i])->getContent());
#endif
		parseFreeBusyLine(mObj->getLines().at(matches[i]));
	}
	parseAttendees();
	parseOrganizer();
	parseDT();
	parseID();
	parseDuration();
	parseURL();
	parseRequestStatus();
	met=method;
}


void VFreeBusy::act()
{
//	#warning to implement the "ACT" method
}





