#ifndef MAILFILTER_PLUGIN_H
#define MAILFILTER_PLUGIN_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qlist.h>

#include "mailfilter.h"


class IndexClass;
class Filter;

class MailFilter: public MailFilterV
{
public:
    MailFilter();
    ~MailFilter();

    virtual void applyFilter( IndexClass*, bool useForwardActions = true );
    virtual QString messageFolder( MessageClass* );
    virtual void configure(QWidget *,const char*);
    void readConfig();

private:
    // current version
    const Version* _mfVersion;
    // Kernel API version required
    const Version* _mfAPIVersion;
    // info
    const Info* _mfInfo;
    // Implicit KoreDialog service
    const Service* _mfService;
    // "Enhanced" (cout) KoreDialog service
    const Service* _mfeService;

    QList<Filter> filters;



};

#endif



