/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <kapp.h>
#include <kconfig.h>
#include <kstddirs.h>
#include <kiconloader.h>

#include <qfileinfo.h>

#include <mainwindow.h>
#include <countriesclass.h>
#include <browsewidget.h>
#include <contentswidget.h>
#include <clipboard.h>
#include <texthtml.h>
#include <orb.h>
#include <esplash.h>
#include <clientvfs.h>
#include <conversions.h>
#include <vmailattribute.h>
#include <setupwizard.h>
#include <brokeriface.h>
#include <noteobj.h>
#include <contactobj.h>
#include <groupobj.h>
#include <mailobj.h>
#include <partobj.h>
#include <attributefactories.h>
#include <ataddressbook.h>
#include <clientnotifier.h>
#include <carddialogwidget.h>
#include <pixlibrary.h>
#include <pluginmanager.h>

#include <unistd.h>
#include <stdio.h>

#include "../plugins/mailfilter/mailfilter_plugin.h"

TextHtmlConvertor *textHtmlConverter;
KConfig *GlobalConfig;
KApplication *Kapp;
MainWindow *MWindow;
ESplash *s;
bool setupDone;

MailFilter *mailFilter;

// Return filename of splash graphic for current time of day
const char *currentSplashGraphic(void);

// splash print
void prints(QString);

// setup-related functions
bool setupWanted(int, char **);
bool shouldSetup(void);
void setup(void);
bool verify(QString);

int main(int argc, char **argv)
{
	static KApplication app(argc, argv, "aethera");
	Kapp=&app;
			
	GlobalConfig=app.config();
	
	if(setupWanted(argc, argv) || shouldSetup())
	{
		setup();
	}
	else
	{
		printf("Configuration successfully initiated.\n");
	}
	
	s=new ESplash(currentSplashGraphic());
	s->show();
	s->setTicks(7,PROGRESS_EYE);
	s->setActive(PROGRESS_EYE, true);
	
	// Init the plug in manager
	PlugInManager::thisInstance()->init();
	
	// Init Mail filters
	mailFilter = new MailFilter();
	
	CountriesClass::thisInstance(locate("appdata","countries.list"));
	s->tick("Setting up appearance...");
	GlobalConfig->setGroup("Appearance");
	s->tick();
	CardPixmaps::thisInstance();
	s->tick();

	s->setTicks(15,PROGRESS_TOOLS);
	s->tick();
	s->setActive(PROGRESS_TOOLS, true);
	app.processEvents();
	s->setActive(PROGRESS_TOOLS,true); // tools
	s->tick("Initializing the text/html convertor...");		
	textHtmlConverter=new TextHtmlConvertor;
  s->tick(); // tools
	printf("Main: Clipboard...");
	s->tick("Initializing the clipboard...");
	ClipboardWrapper::thisInstance();
  s->tick(); // tools
	printf(" done\n");

  printf("Main: Object Request Broker...\n");
	s->tick("Initializing the storage backend...");
  ObjectRequestBroker::thisInstance();
  s->tick(); // tools
  printf(" done\n");
	
	printf("Main: ClientVFS...\n");
	s->tick("Reading folders...");
	ClientVFS::thisInstance()->initHierarchy();
  s->tick(); // tools
	
	// register object factories
	ClientVFS::thisInstance()->registerFactory("notes", new NoteObjectFactory);
  s->tick(); // tools
	ClientVFS::thisInstance()->registerFactory("contacts", new ContactObjectFactory);
  s->tick(); // tools
	ClientVFS::thisInstance()->registerFactory("groups", new GroupObjectFactory);
  s->tick(); // tools
	ClientVFS::thisInstance()->registerFactory("mail", new MailObjectFactory);
  s->tick(); // tools
	ClientVFS::thisInstance()->registerFactory("imap", new MailObjectFactory);
  s->tick(); // tools
	ClientVFS::thisInstance()->registerFactory("part", new PartObjectFactory);
	
	// register attribute factories
	ClientVFS::thisInstance()->registerFactory("vattribute", new VAttributeFactory);
  s->tick(); // tools
	ClientVFS::thisInstance()->registerFactory("vmailattribute", new VMailAttributeFactory);
  s->tick(); // tools
	ClientVFS::thisInstance()->registerFactory("vpartattribute", new VPartAttributeFactory);
  s->tick(); // tools
	ClientVFS::thisInstance()->registerFactory("vfolderattribute", new VFolderAttributeFactory);
  s->tick(); // tools
	ClientVFS::thisInstance()->registerFactory("vblockobjectattribute", new VBlockObjectAttributeFactory);
  s->tick(); // tools
	
	ClientVFS::thisInstance()->useFactories(true);
  s->tick(); // tools
	ClientVFS::thisInstance()->initFolderCache("mail");
  ClientVFS::thisInstance()->createVInstances();
	ClientVFS::thisInstance()->discardFolderCache("mail");
  s->tick(); // tools
	printf(" done\n");

	// addressbook
	s->setActive(0,false);
	s->setActive(1,true);
	printf("Main: addressbook...\n");
	AddressBook::thisInstance();
	printf("Main: done\n");
  	
	printf("Main: Main window...");
	prints("Initializing the user interface:");
	MainWindow *w=new MainWindow();
	printf(" done\n");
	
	prints("Done.");
	app.setTopWidget(w);
	w->setIcon(BarIcon("aethera"));
	s->setActive(PROGRESS_TOOLBARS,false);
	usleep(10000);
	w->show();
	s->hide();
	
	return app.exec();
}

const char *currentSplashGraphic(void)
{
	time_t t = time(NULL);
	struct tm *currentTime = localtime(&t);

	const char *name = "aethera-splash-night";

	if(currentTime->tm_hour > 5)
		name = "aethera-splash-morning";
	if(currentTime->tm_hour > 11)
		name = "aethera-splash-day";
	if(currentTime->tm_hour > 17)
		name = "aethera-splash-evening";
	if(currentTime->tm_hour > 21)
		name = "aethera-splash-night";

	return name;
}

void prints(QString msg)
{
//	s->setMessage(msg);
//	Kapp->processEvents();
}

bool setupWanted(int argc, char **argv)
{
	// verify if any command-line option looks like "-setup"
	for(int i=0;i<argc;i++)
		if(QString(argv[i]).contains("-setup"))
			return true;
	return false;
}

bool shouldSetup()
{
	if(!GlobalConfig) return true;
	
	GlobalConfig->setGroup("Directory");
	QString mdir=GlobalConfig->readEntry("AetheraDir");
	
	// check the config file for the top-level directory
	if(mdir.isEmpty())
	{
		// debug
		printf("Warning: no data directory found in the configuration file\n");
		
		return true;
	}
	
	// check the version info
	QFile ver(mdir+"/.version");
	ver.open(IO_ReadOnly);
	QTextStream txt(&ver);
	QString oldver=txt.readLine();
	if(oldver!="Beta 4")
	{
		printf("Configuration found, older version (%s)\n", (const char *)oldver);
		printf("Please make a fresh install!\n");
		return true; // old version
	}
	
	// check the top level directory and the system directories
	if(verify(mdir) &&
		 verify(mdir+"/internal") &&
		 verify(mdir+"/sysmail_inbox") &&
		 verify(mdir+"/sysmail_outbox") &&
		 verify(mdir+"/sysmail_saved") &&
		 verify(mdir+"/sysmail_sent") &&
		 verify(mdir+"/sysmail_drafts") &&
		 verify(mdir+"/sysmail_deleted") &&
		 verify(mdir+"/syscontacts") &&
		 verify(mdir+"/sysgroups") &&
		 verify(mdir+"/sysnotes")) return false;
		
	return true;
}

bool verify(QString name)
{
	QFileInfo f(name);
	if(f.exists() && f.isReadable() && f.isWritable())
		return true;
	
	// debug
	printf("verify: wrong filename %s\n", (const char *)name);
	return false;
}

void setup()
{
	// debug
	printf("Entering setup mode...\n");

	setupDone=false;	
	SetupWizardDialog *sw=new SetupWizardDialog();
	sw->setCaption("Aethera Beta 4");
	sw->show();
	while(!setupDone)
		kapp->processEvents();
	
	// debug
	printf("Setup done.\n");
	delete sw;
}






