/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <mailer.h>
#include <htmlprocessing.h>
#include <miscfunctions.h>
#include <kmimetype.h>
#include <kmimemagic.h>
#include <indexclass.h>
#include <texthtml.h>
#include <localmailfolder.h>
#include <qcstring.h>
#include <qtextcodec.h>
#include <qfontmetrics.h>
#include <qwidget.h>
#include <vector>
#include <string>

extern KConfig *GlobalConfig;
extern TextHtmlConvertor *textHtmlConverter;

#ifdef IDSTRING
	#undef IDSTRING
#endif

#define IDSTRING "miscfunctions :"

#define DEBUG_MISC_FUNCTIONS

QStringList split(const char *s, char c)
{
  QStringList t;
  QString token, k(s);
  if(c==0) c=',';
  
  for(unsigned i=0;i<k.length();i++)
  {
    if(k[i]==c)
    {
      token.stripWhiteSpace();
      t.append(token);
      token.truncate(0);
    }
    else
      token+=k[i];
  }
  if(!token.isEmpty())
  {
    token.stripWhiteSpace();
    t.append(token);
  }
  return t;
}

/**
 *      EnhancedSplit - the same function as the previous split function,
 * but it ignores separators between "" and with escape sequences
 *
 */
QStringList enhancedSplit(QString source, char split, QStringList escapes)
{
        if(split==0) split=',';
        QStringList t;
        int beginChunk=-1, i=0;
        bool insideQuote=false;
#ifdef DEBUG_MISCFUNCTIONS
        printf("%s\n",(const char *)source);
#endif
        for(unsigned i=0;i<source.length();i++)
        {
                if(source[i]=='\"') insideQuote=!insideQuote;
                if((source[i]==split) && (insideQuote==false))
                {
                        // first i have to check for escapes...
                        bool hasEscape=false;
                        for(unsigned j=0;(hasEscape==false) && (j<escapes.count());j++)
                        {
                                if(i>=escapes[j].length() &&
                                        source.find(escapes[j],i-escapes[j].length(),false)==(i-escapes[j].length()))
                                                hasEscape=true;
                        }
#ifdef DEBUG_MISCFUNCTIONS
                        for(unsigned k=0;k<i;k++) printf(" ");
#endif
                        if(!hasEscape)
                        {
                                t.append(source.mid(beginChunk+1,i-1-beginChunk).stripWhiteSpace());
                                beginChunk=i;
#ifdef DEBUG_MISCFUNCTIONS
                                printf("^\n");
#endif
                        }
#ifdef DEBUG_MISCFUNCTIONS
                        else
                                printf("*\n");
#endif
                }
        }
        if(beginChunk!=source.length()-1)
                t.append(source.mid(beginChunk+1,beginChunk-i-1));

        return t;
}

QString remove(QString source, QString what, bool sensitive=false)
{
        QString copy=source;
        int pos=0;
        while(pos!=-1)
        {
                pos=copy.find(what,0,sensitive);
                if(pos!=-1)
                        copy.remove(pos,what.length());
        }
        return copy;
}

QString toString(QStringList &s)
{
  QString t;
  if(s.count())
    t.append(s[0]);
  for(unsigned i=1;i<s.count();i++)
  {
    t.append(", ");
    t.append(s[i]);
  }
  return t;
}

QString join(QStringList s, QString separator)
{
  QString t;
  if(s.count())
    t.append(s[0]);
  for(unsigned i=1;i<s.count();i++)
  {
    t.append(separator);
    t.append(s[i]);
  }
  return t;
}

const char *getMimeIcon(const char *mimetype)
{
  QString mime(mimetype), mimecat, mimesub;
  mime=mime.lower();
  mimecat=mime.left(mime.find("/"));
  mimesub=mime.mid(mime.find("/")+1);
  if(mimecat=="application")
  {
    if(mimesub=="x-gzip" || mimesub=="x-zip" || mimesub=="x-tar" || mimesub=="zip" || mimesub=="gzip" ||
        mimesub=="tar")
      return "application/x-zip.xpm";
    return "application/octet-stream.xpm";
  }
  if(mimecat=="image")
  {
    if(mimesub=="gif") return "image/gif.xpm";
    if(mimesub=="jpeg") return "image/jpeg.xpm";
    return "image/image.xpm";
  }
  if(mimecat=="text")
  {
    if(mimesub=="html" || mimesub=="htm") return "text/html.xpm";
    return "text/plain.xpm";
  }
  return "application/octet-stream";
}

const char *getMimeType(const char *filename)
{
  QString fname=filename, ext;
  
  fname=fname.lower();
  int k=fname.findRev('.');
  if(k==-1)
    ext="unknown";
  else
    ext=fname.mid(k+1);
  
  if(ext=="zip" || ext=="gz" || ext=="tar" || ext=="tgz" || ext=="bz2" || ext=="z")
    return "application/x-zip";
  if(ext=="txt" || ext=="c" || ext=="cc" || ext=="cpp" || ext=="h" || ext=="hpp" || ext=="patch")
    return "text/plain";
  if(ext=="html" || ext=="htm")
    return "text/html";
  
  return "application/octet-stream";
}

void MIMEunfold(QString &source)
{
	int pos=0;
	int iterPos;
	while((pos=source.find('\n', pos)+1)!=0)
	{
		iterPos=pos;
		if(source[iterPos].isSpace())
			iterPos++;
		if(iterPos!=pos) 
    {
			source.replace(pos-1, iterPos-pos+1, "");
#ifdef DEBUG_MISCFUNCTIONS
				printf(IDSTRING"unfold: pos=%d, iterpos=%d\n", pos, iterPos);
#endif
		}
	}
	source.stripWhiteSpace();
#ifdef DEBUG_MISCFUNCTIONS
		printf(IDSTRING"unfold: Result:\n%s---\n", (const char *)source);
#endif
}

void MIMEfold(QString &str, int maxLength)
{
	int count=0;
	int strLen=str.length();
	for(int i=0;i<strLen;i++)
	{
		count++;
		if(count==maxLength)
		{
			str.insert(i,"\n ");
			count=0;
			strLen++;
		}
		if(str[i]=='\n')
			count=0;
	}
}

void unsetFixedHeight(QWidget *w)
{
	w->setMinimumHeight(0);
	w->setMaximumHeight(QWIDGETSIZE_MAX);
}

void unsetFixedWidth(QWidget *w)
{
	w->setMinimumWidth(0);
	w->setMaximumWidth(QWIDGETSIZE_MAX);
}

void unsetFixedSize(QWidget *w)
{
	unsetFixedWidth(w);
	unsetFixedHeight(w);
}

void updateComboBox(QComboBox *box, QString item, bool addToBox)
{
	int j=-1;
	if(item.stripWhiteSpace().isEmpty())
		j=0;
	else
		for(int i=0;i<box->count();i++)
			if(box->text(i).find(item, 0, false)!=-1) j=i;
	if(j==-1 && addToBox)
	{
		printf("WARNING: NEW ITEM ADDED!\n");
		box->insertItem(item, 0);
		j=0;
	}
	if(j>=0)
		box->setCurrentItem(j);
}

QWidget *traceWindow(QWidget *currentWidget, QString name)
{
	QWidget *result;
	for(result=currentWidget->parentWidget(); result; result=result->parentWidget())
	{
		if(result->className()==name)
			return result;
	}
	return 0;
}

