/***************************************************************************
                 pluginmanager.cpp  -  the plug in manager
                             -------------------
    begin                : Tue Apr 17 15:46:03 EEST 2001
    copyright            : (C) 2001 by theKompany (www.thekompany.com>
    author               : Eugen Constantinescu
    email                : eug@thekompany.com
 ***************************************************************************/

#ifndef PLUGINMANAGER_H
#define PLUGINMANAGER_H

#include <kore/kore.h>
#include <kore/kernel.h>
#include <kore/servicemanager.h>
#include <kore/modulemanager.h>
#include <kore/pluginloader.h>
#include <kore/plugin.h>

#include <list>

using namespace kore;

typedef list<Plugin*> PlugInList;
typedef PlugInList::iterator PlugInIt;

/**
 * Main Kore plug in manager.
 * It loads the plug ins and starts the Kernel
 */
class PlugInManager
{
  public:
    /** Init the kernel, the plugin loader, the service manager.*/
    PlugInManager();
    /** Delete all the attributes.*/
    ~PlugInManager();
    /** Return the plugin manager instance.*/
		static PlugInManager *thisInstance();
		/** Load the plug ins.*/
		void init();
		/** The public plugin loader.*/
    PluginLoader* plugInLoader;
    ServiceManager* serviceManager;
  private:
    /** The singleton instance.*/
    static PlugInManager* inst;
    /** The plug in manager kernel.*/
    Kernel* kernel;
    /** The loaded plug ins list.*/
    PlugInList plugInList;
} ;

#endif

