.\"	$Id: mailcap.man,v 1.1 1997/11/16 00:28:02 malc Exp $
.TH MAILCAP %SEC5%
.SH NAME
mailcap \- MIME capabilities file, as used by af
.SH DESCRIPTION
The 
.I mailcap
file lists the known MIME content-types, and describes how to display,
print, and compose each content-type.
.PP
Lines in the file which start with a '#' are treated as comments and
ignored, as are blank lines.  Each other line contains a single
mailcap entry.  Long entries may be continued onto the next line by
ending them with a '\\'.
.PP
Each mailcap entry consists of at least a
.BR content-type,
and a
.B command
to execute to display that content-type.  It may be followed by one or
more optional fields, which give further information about how to
handle the content-type.
.PP
The
.B content-type
may be any valid MIME content-type, in the form
.BR type/subtype.
In addition, if no subtype is specified, or a '*' is used as the
subtype, then the content-type will match any subtype of the primary
type.
.PP
The
.B command
may be any UNIX command, and is called to display messages of the given
content-type.  All commands must follow the same rules, including those
specfied in optional fields.
.PP
Any '\\' or ';' characters in a command string must be quoted with a
'\\'.  The following escape sequences are allowed within command
strings:
.TP
.B %s
Is replaced by the name of a temporary file containing the message body.
.TP
.B %t
Is replaced by the content-type of the message, excluding any parameters.
.BI %{"param"}
Is replaced by the value of the parameter named in
.IR param,
or a blank string if no such parameter has been specified.
.TP
.B %n
Is replaced by the number of body parts if the message is a
multipart message, or '0' otherwise.
.TP
.B %F
If the message is a multipart message, then this is replaced with a
space-separated list of values, two for each body part.  The values
give first the content-type of the body part, and then the name of a
temporary file where it has been stored.
.SH Optional Fields
The optional fields, which can give more information about a
content-type are:
.TP 
.BI test="command"
Describes a command which should be run successfully (ie. returning 0)
before the mailcap entry is used.  The most common is
"test -n $DISPLAY".
.TP
.BI print="command"
Describes the command used to print the content-type.
.TP
.BI edit="command"
Describes a command to edit a file containing the body of a message
of the given content-type.
.TP
.BI compose="command"
.br
.ns
.TP
.BI composetyped="command"
.br
Describes a command to compose a file containing the body of a message
of the given content-type.  Any command specified by the
.B composetyped
command, must also include a
.I Content-Type:
header in the output, which allows the composing command to add
parameters to the content-type.
.TP
.BI desc="text"
A textual description of the content-type.
.TP
.BI file="template"
If any command includes the
.B %s
escape, then this field can specify a format for the filename.
If
.B %s
appears in the template, then it will be replaced with characters
to make the name unique.
.B 
.TP
.BI needsterminal
Indicates that the command is interactive, and needs control of
a terminal window to function.
.TP
.BI copiousoutput
Indicates that the output of the command should be displayed via
a pager.
.TP
.BI textualnewlines
Forces af to treat newlines in the message body as it would for text,
even though the content-type is not a subtype of text.
.TP
.BI x11-bitmap="filename"
Names a file where a bitmap which can be used to mark this content-type
is stored.  Not used by af.
.SH EXAMPLE
.RS 4n
.nf
# A partial mailcap file

# Handle text/enriched and text/richtext
text/enriched; richtext -e; copiousoutput; \\
description="Enriched text"
text/richtext; richtext; copiousoutput; \\
description="Richtext"

# Display audio/basic using the audio device
audio/basic; cat > /dev/audio; \\
description="An audio fragment"

# Handle PostScript files by printing them
# (this is a security hole)
application/postscript; lpr %s; \\
description="A PostScript File"
.fi
.SH FILES
$HOME/.mailcap
user's mailcap file
.TP
%ETCDIR%/mailcap
global mailcap file for af.
.TP
/etc/mailcap,
.br
.ns
.TP
/usr/etc/mailcap,
.br
.ns
.TP
/usr/local/etc/mailcap
.br
global mailcap files for all mailers.
.PD
.SH Author
Malc Arnold, based on a specification by Nathaniel Borenstein.
.SH SEE ALSO
af(%SEC1%), ``The Af Reference Manual'', rfc1524.
