# ---------------------------------------------------------------------------
# - APX0003.als                                                             -
# - afnix:apx test module                                                   -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2007 amaury darsch                                   -
# ---------------------------------------------------------------------------

# @info   request node test module
# @author amaury darsch

# load the project
interp:load "apx-prjld"

# create a message node
const rqst (afnix:apx:request)
# check node size (head only)
assert 1   (rqst:child-length)

# get the head node
const head (rqst:get-head-node)
# check the node name
assert "apx:head" (head:get-name)

# set the node command value
rqst:set-command "help"
assert "help" (rqst:get-command-value)

# add a node argument value
rqst:add-argument-name-value "count" 1
assert "1" (rqst:get-argument-name-value "count")

# create a property list with a an argument
const plist (Plist)
plist:add "project" "apx"

# add the property list
rqst:add-argument-list plist

# add another argument
rqst:add-argument-value "hello"

# get the argument vector
const  argv (rqst:get-argument-vector)
assert 3       (argv:length)
assert "1"     (argv:get 0)
assert "apx"   (argv:get 1)
assert "hello" (argv:get 2)

# get the argument lst
const  argl  (rqst:get-argument-list)
assert true  (argl:exists-p "project")
assert "apx" (argl:get-value "project")
