// ---------------------------------------------------------------------------
// - t_sha256.cpp                                                            -
// - afnix cryptography - sha256 class tester module                         -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Sha256.hpp"

int main (int, char**) {
  using namespace afnix;

  // create a SHA-256 message digest
  Sha256 md;
  if (md.getname () != "SHA-256") return 1;

  // check digest as specified in FIPS PUB 180-2
  String digest = md.compute ("abc");
  if (digest != "BA7816BF" "8F01CFEA" "414140DE" "5DAE2223"
                "B00361A3" "96177A9C" "B410FF61" "F20015AD") return 1;
  // the afnix test as usual
  digest = md.compute ("afnix");
  if (digest != "DEBDB627" "802EECBF" "0171E229" "D9470CB6"
                "E94DD7E7" "13D80E61" "D0B877A0" "1B56AF2F") return 1;
  digest = md.compute ("afnix programming language");
  if (digest != "B229D2E4" "F4DEFD37" "074AB172" "4A3AF20E"
                "32DBAA86" "D9158DC7" "466902D6" "34AFB110") return 1;
  // success
  return 0;
}
