// ---------------------------------------------------------------------------
// - HttpProto.hpp                                                           -
// - afnix:nwg module - http protocol base class definition                  -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_HTTPPROTO_HPP
#define  AFNIX_HTTPPROTO_HPP

#ifndef  AFNIX_PLIST_HPP
#include "Plist.hpp"
#endif

#ifndef  AFNIX_BUFFER_HPP
#include "Buffer.hpp"
#endif

namespace afnix {

  /// the HttpProto class is a base class that ease the deployement of the
  /// http protocol. The base class is built with a property list which is
  /// used to define the message header. The class alo defines the write
  /// methods which are used to write a message either on an output stream
  /// or into a buffer.
  /// @author amaury darsch

  class HttpProto : public virtual Object {
  public:
    /// map a http status code
    /// @param code the code to map
    static String mapcode (const long code);

  protected:
    /// the http plist
    Plist d_head;

  public:
    /// set a header property
    /// @param name the property name
    /// @param lval the property value
    virtual void sethead (const String& name, const Literal& pval);

    /// write the http header to an output stream
    /// @param os the output stream
    virtual void write (Output& os) const;

    /// write the http header to a buffer
    /// @param buf the target buffer
    virtual void write (Buffer& buf) const;

  public:
    /// @return true if the given quark is defined
    bool isquark (const long quark, const bool hflg) const;

    /// apply this object with a set of arguments and a quark
    /// @param robj  the current runnable
    /// @param nset  the current nameset    
    /// @param quark the quark to apply these arguments
    /// @param argv  the arguments to apply
    Object* apply (Runnable* robj, Nameset* nset, const long quark,
                   Vector* argv);
  };
}

#endif
