// ---------------------------------------------------------------------------
// - XhtmlPre.cpp                                                            -
// - afnix:wax module - xhtml pre node class implementation                  -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2007 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "XhtmlPre.hpp"
#include "Exception.hpp"

namespace afnix {

  // -------------------------------------------------------------------------
  // - private section                                                       -
  // -------------------------------------------------------------------------

  // the pre node name
  static const String XML_TAG_NAME = "pre";
  // the clas attribute
  static const String XML_CLS_NAME = "class";

  // -------------------------------------------------------------------------
  // - class section                                                         -
  // -------------------------------------------------------------------------

  // create a default pre node

  XhtmlPre::XhtmlPre (void) : XmlTag (XML_TAG_NAME) {
  }

  // create a xhtml pre node with a class

  XhtmlPre::XhtmlPre (const String& cls) : XmlTag (XML_TAG_NAME) {
    setattr (XML_CLS_NAME, cls);
  }

  // return the class name

  String XhtmlPre::repr (void) const {
    return "XhtmlPre";
  }

  // -------------------------------------------------------------------------
  // - object section                                                        -
  // -------------------------------------------------------------------------

  // create a new object in a generic way

  Object* XhtmlPre::mknew (Vector* argv) {
    long argc = (argv == nilp) ? 0 : argv->length ();
    // check for 0 argument
    if (argc == 0) return new XhtmlPre;
    // check for 1 argument
    if (argc == 1) {
      String cls = argv->getstring (0);
      return new XhtmlPre (cls);
    }
    // wrong arguments
    throw Exception ("argument-error", 
		     "too many arguments with xhtml pre constructor");
  }
}
