/*******************************************************************************
 *  PROJECT: GNOME Colorscheme
 *
 *  AUTHOR: Jonathon Jongsma
 *
 *  Copyright (c) 2005 Jonathon Jongsma
 *
 *  License:
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the 
 *    Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 *    Boston, MA  02111-1307  USA
 *
 *******************************************************************************/

#include "gcs-schemeselector.h"
#include "core/gcs-scheme.h"
#include "gcs-i18n.h"

namespace gcs
{
    namespace Widgets
    {

        SchemeSelector::SchemeSelector(void)
            : m_refListStore(Gtk::ListStore::create(m_columns))
            {

                // Add items to the model
                Gtk::TreeModel::Row row;
                row = *(m_refListStore->append());
                row[m_columns.m_columnText] = _("Complements");
                row[m_columns.m_columnCode] = SCHEME_COMPLEMENTS;
                row = *(m_refListStore->append());
                row[m_columns.m_columnText] = _("Split-Complements");
                row[m_columns.m_columnCode] = SCHEME_SPLIT_COMPLEMENTS;
                row = *(m_refListStore->append());
                row[m_columns.m_columnText] = _("Triads");
                row[m_columns.m_columnCode] = SCHEME_TRIADS;
                row = *(m_refListStore->append());
                row[m_columns.m_columnText] = _("Tetrads");
                row[m_columns.m_columnCode] = SCHEME_TETRADS;
                row = *(m_refListStore->append());
                row[m_columns.m_columnText] = _("Analogous");
                row[m_columns.m_columnCode] = SCHEME_ANALOGOUS;
                row = *(m_refListStore->append());
                row[m_columns.m_columnText] = _("Monochromatic");
                row[m_columns.m_columnCode] = SCHEME_MONOCHROMATIC;

                set_model(m_refListStore);

                // Display the m_columnText column in the ComboBox
                pack_start(m_columns.m_columnText);

                // set the first choice as the active item
                set_scheme_type(SCHEME_TRIADS);

            }


        SchemeSelector::~SchemeSelector(void)
        { }


        tSchemeType SchemeSelector::get_scheme_type(void)
        {
            Gtk::TreeModel::Row row;
            row = *(get_active());
            return row.get_value(m_columns.m_columnCode);
        }


        void SchemeSelector::set_scheme_type(tSchemeType t)
        {
            Gtk::TreeModel::Children children = get_model()->children();
            for (Gtk::TreeModel::Children::iterator it = children.begin();
                    it != children.end(); it++)
            {
                if ((*it)[m_columns.m_columnCode] == t)
                {
                    set_active(it);
                    break;
                }
            }
        }

    } // namespace Widgets
} // namespace gcs
