#ifndef CalendarDomain_h
#define CalendarDomain_h

#include <Foundation/Foundation.h>
#include <CalendarProtocols.h>

#include "CalendarGroup.h"

@class CalendarUser;
@protocol CalendarUser;
@class CalendarEvent;

@interface CalendarDomain:NSObject <CalendarPrimitive>
{
	NSString *_name;
	CalendarUser *__root;

	NSMutableDictionary *_userDict;
}

+ (NSArray *) allCalendarDomains;
+ (NSArray *) allCalendarDomainNames;
+ (CalendarDomain *) calendarDomainNamed:(NSString *)name;
+ (CalendarDomain *) calendarDomainWithName:(NSString *)name;

- (id) initWithDomainName:(NSString *)name;
- (NSString *) name;

- (CalendarUser *) owner;

/*
- (BOOL) calendarUser:(CalendarUser *)user
canModifyCalendarPrimitive:(id <CalendarPrimitive>)obj;

- (BOOL) calendarUser:(CalendarUser *)user
canAppendCalendarPrimitive:(id <CalendarPrimitive>)obj;

- (BOOL) calendarUser:(CalendarUser *)user
canReadCalendarPrimitive:(id <CalendarPrimitive>)obj;

- (CalendarUser *) requestCalendarUserWithName:(NSString *)name;

- (CalendarEvent *) requestCalendarEventForCalendarUser:(CalendarUser *)user
									  calendarEventName:(NSString *)name
												  group:(CalendarGroup *)group;

- (CalendarUser *) calendarUserWithName:(NSString *)name;
- (BOOL) containsCalendarUserWithName:(NSString *)name;
- (void) setCalendarEvent:(CalendarEvent *)event;

- (void) setCalendarUser:(CalendarUser *)user;

- (NSArray *) allUsers;
*/

@end
#endif
