/* aide, Advanced Intrusion Detection Environment
 *
 * Copyright (C) 1999,2000 Rami Lehti, Pablo Virolainen
 * $Header: /cvs-root-aide/aide/src/db_file.c,v 1.59 2002/02/10 19:10:32 rammer Exp $
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <stdlib.h>
#include <time.h>

#include <errno.h>

#include "types.h"
#include "base64.h"
#include "db_file.h"
#include "conf_yacc.h"
#include "util.h"
#include "aide.h"
#include "db_sql.h" /* typedefs */
#include "commandconf.h"
/*for locale support*/
#include "locale-aide.h"
/*for locale support*/

#ifdef WITH_MHASH
#include <mhash.h>
#endif

#ifdef WITH_ZLIB
#include <zlib.h>
#endif

#include <gcrypt.h>

#define BUFSIZE 16384

extern int db_scan(); /* Rumaa.... */
extern char* dbtext; /* Todella rumaa... */
extern long db_lineno;


extern void db_buff(FILE*);

#ifdef WITH_ZLIB
#define ZBUFSIZE 16384

void handle_gzipped_input(int out){

  int nread=0;
  int err=0;
  int* buf=malloc(ZBUFSIZE);
  buf[0]='\0';
  error(200,"handle_gzipped_input(),%d\n",out);
  while(!gzeof(conf->db_gzin)){
    if((nread=gzread(conf->db_gzin,buf,ZBUFSIZE))<0){
      error(0,"gzread() failed!\n");
      exit(1);
    } else {
      /* gzread returns 0 even if uncompressed bytes were read*/
      if(nread==0){
	write(out, buf,strlen((char*)buf));
      } else {
	write(out, buf,nread);
      }
      error(240,"nread=%d,strlen(buf)=%d,errno=%s,gzerr=%s\n",
	    nread,strlen((char*)buf),strerror(errno),
	    gzerror(conf->db_gzin,&err));
      buf[0]='\0';
    }
  }
  close(out);
  error(240,"handle_gzipped_input() exiting\n");
  exit(0);
  /* NOT REACHED */
  return;
}
#endif


int dofflush(void)
{

  int retval;
#ifdef WITH_ZLIB
  if(conf->gzip_dbout){
    retval=gzflush(conf->db_gzout,Z_SYNC_FLUSH);
  }else {
#endif
    retval=fflush(conf->db_out); 
#ifdef WITH_ZLIB
  }
#endif

  return retval;
}

int dofprintf( const char* s,...)
{
  int retval;
  char* temp=NULL;
  va_list ap;
  
  va_start(ap,s);
#ifdef WITH_ZLIB
  if(conf->gzip_dbout){
    temp=(char*)malloc(BUFSIZE);
    if(temp==NULL){
      error(0,"Unable to alloc %i bytes\n",BUFSIZE);
      return -1;
    }
    retval=vsnprintf(temp,BUFSIZE,s,ap);
    retval=gzwrite(conf->db_gzout,temp,retval);
    free(temp);
  }else{
#endif
    retval=vfprintf(conf->db_out,s,ap);
#ifdef WITH_ZLIB
  }
#endif
  va_end(ap);

  return retval;
}



int db_file_read_spec(db_config* conf){
  
  int i=0;

  conf->db_in_order=(DB_FIELD*) malloc(1*sizeof(DB_FIELD));
  
  while ((i=db_scan())!=TNEWLINE){
    switch (i) {
      
    case TID : {
      int l;
      

      /* Yes... we do not check if realloc returns nonnull */

      conf->db_in_order=(DB_FIELD*)
	realloc((void*)conf->db_in_order,
		(conf->db_in_size+1)*sizeof(DB_FIELD));
      
      
      conf->db_in_order[conf->db_in_size]=db_unknown;
      
      for (l=0;l<db_unknown;l++){
	
	if (strcmp(db_names[l],dbtext)==0) {
	  
	  if (check_db_order(conf->db_in_order, conf->db_in_size,
			     db_value[l])==RETFAIL) {
	    error(0,"Field %s redefined in @@dbspec\n",dbtext);
	    conf->db_in_order[conf->db_in_size]=db_unknown;
	  } else {
	    conf->db_in_order[conf->db_in_size]=db_value[l];
	  }
	  conf->db_in_size++;
	  break;
	}
      }
      for (l=0;l<db_alias_size;l++){
	
	if (strcmp(db_namealias[l],dbtext)==0) {
	  
	  if (check_db_order(conf->db_in_order, conf->db_in_size,
			     db_aliasvalue[l])==RETFAIL) {
	    error(0,"Field %s redefined in @@dbspec\n",dbtext);
	    conf->db_in_order[conf->db_in_size]=db_unknown;
	  } else {
	    conf->db_in_order[conf->db_in_size]=db_aliasvalue[l];
	  }
	  conf->db_in_size++;
	  break;
	}
      }
      if(l==db_unknown){
	error(0,"Unknown field %s in database\n",dbtext);
	conf->db_in_size++;
      }
      break;
    }
    
    case TDBSPEC : {
      error(0,"Only one @@dbspec in inputdatabase.\n");
      return RETFAIL;
      break;
    }
    
    default : {
      error(0,"Aide internal error while reading inputdatabase.\n");
      return RETFAIL;
    }
    }
  }

  /* Lets generate attr from db_in_order if database does not have attr */
  conf->attr=-1;

  for (i=0;i<conf->db_in_size;i++) {
    if (conf->db_in_order[i]==db_attr) {
      conf->attr=1;
    }
  }
  if (conf->attr==-1) {
    conf->attr=0;
    error(0,"Database does not have attr field.\nComparation may be incorrect\nGenerating attr-field from dbspec\nIt might be a good Idea to regenerate databases. Sorry.\n");
    for(i=0;i<conf->db_in_size;i++) {
      conf->attr|=1<<conf->db_in_order[i];
    }
  }
  return RETOK;
}

char** db_readline_file(db_config* conf){
  
  char** s=NULL;
  
  int i=0;
  int r;
  int a=0;
  int token=0;
  
  if (conf->db_in_size==0) {
    db_buff(conf->db_in);
    
    token=db_scan();
    while((token!=TDBSPEC)){

      switch(token){
      case TUNKNOWN: {
	continue;
	break;
      }
      case TGZIPHEADER: {

#ifndef WITH_ZLIB
	error(0,"Zlib support is not compiled in.\n");
	return NULL;
#else
	int pipefd[2];
	pid_t retval=0;
	/* Is this safe? Can we always fseek back? Probably.*/
	fseek(conf->db_in,0L,SEEK_SET);
	if(pipe(pipefd)<0){
	  error(0,"Couldn't open a pipe for zipped input\n");
	  return NULL;
	}
	if((retval=fork())==0){
	  /* The child process */
	  close(pipefd[0]);
	  conf->db_gzin=gzdopen(fileno(conf->db_in),"rb");
	  /* WARNING This causes weird problems. Don't do it.
	     fclose(conf->db_in);
	  */
	  handle_gzipped_input(pipefd[1]);
	} else {
	  /* The parent */
	  fclose(conf->db_in);
	  conf->db_in=fdopen(pipefd[0],"r");
	  db_buff(conf->db_in);
	  close(pipefd[1]);
	}
#endif
	break;
      }
      default: {
	/* If it is anything else we quit */
	/* Missing dbspec */
	token=TEOF;
	break;
      }
      }
      if(token==TEOF){
	break;
      }

      token=db_scan();
    }

    if (token!=TDBSPEC) {
      /*
       * error.. must be a @@dbspec line
       */
      
      switch (conf->db_in_url->type) {
      case url_file : {
	error(0,"Filedatabase must have one db_spec spesification\n");
	break;
      }

      case url_stdin : {
	error(0,"Pipedatabase must have one db_spec spesification\n");
	break;
      }

      case url_fd: {
	error(0,"FD-database must have one db_spec spesification\n");
	break;
      }

      default : {
	error(0,"db_readline_file():Unknown or unsupported db in type.\n");
	
	break;
      }
      
      }
      return s;
    }
    
    /*
     * Here we read da spec
     */
    
    if (db_file_read_spec(conf)!=0) {
      /* somethin went wrong */
      return s;
    }
    
  }
  
  s=(char**)malloc(sizeof(char*)*db_unknown);

  /* We NEED this to avoid Bus errors on Suns */
  for(i=0;i<db_unknown;i++){
    s[i]=NULL;
  }
  
  for(i=0;i<conf->db_in_size;i++){
    switch (r=db_scan()) {
      
    case TDBSPEC : {
      
      error(0,"Databasefile can have only one db_spec.\nTrying to continue on line %i\n",db_lineno);
      
      /*
	if (conf->db_in_order[i]!=db_unknown) {
	s[conf->db_in_order[i]]=(char*)strdup(dbtext);
      }
      */
      
      break;
    }
    case TNAME : {
      if (conf->db_in_order[i]!=db_unknown) {
	s[conf->db_in_order[i]]=(char*)strdup(dbtext);
      }
      break;
    }
    
    case TID : {
      if (conf->db_in_order[i]!=db_unknown) {
	s[conf->db_in_order[i]]=(char*)strdup(dbtext);
      }
      break;
    }
    
    case TNEWLINE : {
      
      if (i==0) {
	i--;
	break;
      }
      
      /*  */

      error(0,"Not enough parameters in db:%i. Trying to continue.\n",
	    db_lineno);
      for(a=0;a<i;a++){
	free(s[conf->db_in_order[a]]);
	s[conf->db_in_order[a]]=NULL;
      }
      i=0;
      break;

    }

    case TEOF : {
	
      /* This can be the first token on a line */
      if(i>0){
	error(0,"Not enough parameters in db:%i\n",db_lineno);
      };
      for(a=0;a<i;a++){
	free(s[conf->db_in_order[a]]);
      }
      free(s);
      return NULL;
      break;
    }
    case TERROR : {
      error(0,"There was an error in the database file on line:%i.\n",db_lineno);
      break;
    }
    
    default : {
      
      error(0,"Not implemented in db_readline_file %i\n\"%s\"",r,dbtext);
      
      free(s);
      s=NULL;
      i=conf->db_in_size;
      break;
    }
    }
    
  }
  

  /*
   * If we don't get newline after reading all sells we print an error
   */
  a=db_scan();

  if (a!=TNEWLINE&&a!=TEOF) {
    error(0,"Newline exptexted in database. Readin until end of line\n");
    do {
      
      error(0,"Skipped value %s\n",dbtext);
      
      /*
       * Null statement
       */ 
      a=db_scan();
    }while(a!=TNEWLINE&&a!=TEOF);
    
  }
  
  return s;
  
}

int db_writechar(char* s,FILE* file,int i)
{
  char* r=NULL;
  int retval=0;

  if(i) {
    dofprintf(" ");
  }

  if(s==NULL){
    retval=dofprintf("0");
    return retval;
  }
  if(s[0]=='\0'){
    retval=dofprintf("0-");
    return retval;
  }
  if(s[0]=='0'){
    retval=dofprintf("00");
    if(retval<0){
      return retval;
    }
    s++;
  }

  r=CLEANDUP(s);
  retval=dofprintf("%s",r);
  free(r);

  return retval;
}

int db_writeint(long i,FILE* file,int a)
{
  if(a) {
    dofprintf(" ");
  }
  
  return dofprintf("%li",i);
  
}

int db_write_byte_base64(byte*data,size_t len,FILE* file,int i )
{
  char* tmpstr=NULL;
  int retval=0;
  
  tmpstr=encode_base64(data,len);
  if(i){
    dofprintf(" ");
  }

  if(tmpstr){
    retval=dofprintf(tmpstr);
    free(tmpstr);
    return retval;
  }else {
    return dofprintf("0");
  }
  return 0;

}

int db_write_time_base64(time_t i,FILE* file,int a)
{
  static char* ptr=NULL;
  char* tmpstr=NULL;
  int retval=0;

  if(a){
    dofprintf(" ");
  }

  if(i==0){
    retval=dofprintf("0");
    return retval;
  }


  ptr=(char*)malloc(sizeof(char)*TIMEBUFSIZE);
  if (ptr==NULL) {
    error(0,"\nCannot allocate memory..\n");
    abort();
  }
  memset((void*)ptr,0,sizeof(char)*TIMEBUFSIZE);

  sprintf(ptr,"%li",i);


  tmpstr=encode_base64(ptr,strlen(ptr));
  retval=dofprintf(tmpstr);
  free(tmpstr);
  free(ptr);

  return retval;

}

int db_writeoct(long i, FILE* file,int a)
{
  if(a) {
    dofprintf(" ");
  }
  
  return dofprintf("%lo",i);
  
}

int db_writespec_file(db_config* conf)
{
  int i=0;
  int j=0;
  int retval=1;
  struct tm* st;
  time_t tim=time(&tim);
  st=localtime(&tim);

  retval=dofprintf(
		 "# This file was generated by Aide, version %s\n"
		 "# Time of generation was %.4u-%.2u-%.2u %.2u:%.2u:%.2u\n",
		 AIDEVERSION,
		 st->tm_year+1900, st->tm_mon+1, st->tm_mday,
		 st->tm_hour, st->tm_min, st->tm_sec
		 );
  if(retval==0){
    return RETFAIL;
  }

  retval=dofprintf("@@db_spec ");
  if(retval==0){
    return RETFAIL;
  }
  for(i=0;i<conf->db_out_size;i++){
    for(j=0;j<db_unknown;j++){
      if(db_value[j]==conf->db_out_order[i]){
	retval=dofprintf("%s ",db_names[j]);
	if(retval==0){
	  return RETFAIL;
	}
	break;
      }
    }
  }
  retval=dofprintf("\n");
  if(retval==0){
    return RETFAIL;
  }
  return RETOK;
}

#ifdef WITH_SUN_ACL
int db_writeacl(acl_type* acl,FILE* file,int a){
  int i;

  if(a) {
    dofprintf(" ");
  }
  
  if (acl==NULL) {
    dofprintf("0");
  } else {
    
    dofprintf("%i",acl->entries);
    
    for (i=0;i<acl->entries;i++) {
      dofprintf(",%i,%i,%i", acl->acl[i].a_type, acl->acl[i].a_id,
	      acl->acl[i].a_perm);
    }
  }
  return RETOK;
}
#endif

int db_writeline_file(db_line* line,db_config* conf){
  int i;

  for(i=0;i<conf->db_out_size;i++){
    switch (conf->db_out_order[i]) {
    case db_filename : {
      db_writechar(line->filename,conf->db_out,i);
      break;
    }
    case db_linkname : {
      db_writechar(line->linkname,conf->db_out,i);
      break;
    }
    case db_bcount : {
      db_writeint(line->bcount,conf->db_out,i);
      break;
    }

    case db_mtime : {
      db_write_time_base64(line->mtime,conf->db_out,i);
      break;
    }
    case db_atime : {
      db_write_time_base64(line->atime,conf->db_out,i);
      break;
    }
    case db_ctime : {
      db_write_time_base64(line->ctime,conf->db_out,i);
      break;
    }
    case db_inode : {
      db_writeint(line->inode,conf->db_out,i);
      break;
    }
    case db_lnkcount : {
      db_writeint(line->nlink,conf->db_out,i);
      break;
    }
    case db_uid : {
      db_writeint(line->uid,conf->db_out,i);
      break;
    }
    case db_gid : {
      db_writeint(line->gid,conf->db_out,i);
      break;
    }
    case db_size : {
      db_writeint(line->size,conf->db_out,i);
      break;
    }
    case db_md5 : {
      db_write_byte_base64(line->md5,
			   gcry_md_get_algo_dlen(GCRY_MD_MD5),conf->db_out,i);
      break;
    }
    case db_sha1 : {
      db_write_byte_base64(line->sha1,
			   gcry_md_get_algo_dlen(GCRY_MD_SHA1),conf->db_out,i);
      break;
    }
    case db_rmd160 : {
      db_write_byte_base64(line->rmd160,
			   gcry_md_get_algo_dlen(GCRY_MD_RMD160),
			   conf->db_out,i);
      break;
    }
    case db_tiger : {
      db_write_byte_base64(line->tiger,
			   gcry_md_get_algo_dlen(GCRY_MD_TIGER),
			   conf->db_out,i);
      break;
    }
    case db_perm : {
      db_writeoct(line->perm,conf->db_out,i);
      break;
    }
#ifdef WITH_MHASH
    case db_crc32 : {
      db_write_byte_base64(line->crc32,
			   mhash_get_block_size(MHASH_CRC32),
			   conf->db_out,i);
      break;
    }
    case db_crc32b : {
      db_write_byte_base64(line->crc32b,
			   mhash_get_block_size(MHASH_CRC32B),
			   conf->db_out,i);
      break;
    }
    case db_haval : {
      db_write_byte_base64(line->haval,
			   mhash_get_block_size(MHASH_HAVAL256),
			   conf->db_out,i);
      break;
    }
    case db_gost : {
      db_write_byte_base64(line->gost ,
			   mhash_get_block_size(MHASH_GOST),
			   conf->db_out,i);
      break;
    }
#endif
    case db_attr : {
      db_writeint(line->attr,
		  conf->db_out,i);
      break;
    }
#ifdef WITH_ACL
    case db_acl : {
      db_writeacl(line->acl,conf->db_out,i);
      break;
    }
#endif
    case db_checkmask : {
      db_writeoct(line->attr,conf->db_out,i);
      break;
    }
    default : {
      error(0,"Not implemented in db_writeline_file %i\n",
	    conf->db_out_order[i]);
      return RETFAIL;
    }
    
    }
    
  }

  dofprintf("\n");
  /* Can't use fflush because of zlib.*/
  dofflush();

  return RETOK;
}

int db_close_file(db_config* conf){

#ifndef WITH_ZLIB
  if(fclose(conf->db_out)){
    error(0,"Unable to close database:%s\n",strerror(errno));
    return RETFAIL;
  }
#else
  if(conf->gzip_dbout){
    if(gzclose(conf->db_gzout)){
      error(0,"Unable to close gzdatabase:%s\n",strerror(errno));
      return RETFAIL;
    }
  }else {
    if(fclose(conf->db_out)){
      error(0,"Unable to close database:%s\n",strerror(errno));
      return RETFAIL;
    }
  }
#endif

  return RETOK;
}
