// ClientSocket.cpp : implementation file
//

#include "stdafx.h"
#include "aime_w32.h"
#include "ClientSocket.h"
#include "mudtypes.h"
#include "strings.h"
#include "newfuncts.h"
#include "global.h"
#include "sysdep.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CClientSocket

CClientSocket::CClientSocket()
{
	valid_input = FALSE;
	locked = FALSE;
}

CClientSocket::~CClientSocket()
{
}


// Do not edit the following lines, which are needed by ClassWizard.
#if 0
BEGIN_MESSAGE_MAP(CClientSocket, CSocket)
	//{{AFX_MSG_MAP(CClientSocket)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
#endif	// 0

/////////////////////////////////////////////////////////////////////////////
// CClientSocket member functions

void CClientSocket::OnConnect(int nErrorCode)
{
	AfxMessageBox("Connection complete");
}


void CClientSocket::OnReceive(int nErrorCode)
{
   char    input_buffer[MAX_COM_LEN+4];
   Strings *the_input;
   char holder[MAX_COM_LEN];
   int holder_count = 0;
   BOOL the_end = FALSE;

   // We need to avoid letting two connection-accessing cycles run concurrently so while this
   // is locked, we sleep it off
   while (set_locked() == FALSE)
		Sleep(10);

   the_input = new_Strings();
   for (int x=0; x<the_config.maxreadsperpoll; x++)
   {
		BZERO(input_buffer,MAX_COM_LEN+3);

		the_end = FALSE;
		if (Receive(input_buffer, MAX_COM_LEN - 1) == SOCKET_ERROR)
		{
			if (GetLastError() == WSAEMSGSIZE)
				the_end = FALSE;
			else
				the_end = TRUE;
		}
		else
			the_end = TRUE;

        if (*input_buffer != '\0')
        {
           size_t i;

           /* remove all wierd telnet function chars */

           for (i=0; i < strlen(input_buffer); i++)
	       {
              if ((input_buffer[i] == '\n') || (input_buffer[i] == '\r'))
			  {
                 if ((input_buffer[i+1]) &&
                     ((input_buffer[i+1] == '\n') ||
                      (input_buffer[i+1] == '\r')))
                    i++;
                 holder[holder_count] = '\n';
                 holder[holder_count+1] = '\0';

                 if (partial_line.str_show() != NULL)
				 {
                    the_input->str_copy(partial_line.str_show());
                    partial_line.truncate(0);
                 }
                 the_input->str_cat(holder);

                 holder_count = -1;

              }
              else if (input_buffer[i] > 1)
			  {
                 holder[holder_count] = input_buffer[i];
              }

              holder_count++;
           }

           if (holder_count != 0)
	       {
              holder[holder_count] = '\0';
              partial_line.str_cat(holder);
              holder[0] = '\0';
              holder_count = 0;
           }
           else
              partial_line.truncate(0);

           if (the_input->str_len() == 0)
		   {
			   unlock();
              return;
		   }


           read_buffer.str_cat(the_input->str_show());
        }
        the_input->truncate(0);	
		if (the_end == TRUE)
			break;

   } // main for
   valid_input = TRUE;
   delete_Strings(the_input);

   unlock();
   if (read_buffer.str_show() == NULL)
      return;

   return;
}


/***********************************************************************
 ** set_locked - locks this socket.  If it has already been locked,
 **              returns FALSE, otherwise returns TRUE
 ***********************************************************************/

BOOL CClientSocket::set_locked()
{
	if (locked)
		return FALSE;

	locked = TRUE;
	return TRUE;
}


/***********************************************************************
 ** unlock - unlocks the socket so it is free for use
 ***********************************************************************/

void CClientSocket::unlock()
{
	locked = FALSE;
}
