#ifndef _ABILITY_H
#define _ABILITY_H

#include "mudtypes.h"
#include "entity.h"

class Builder;

enum abil_str_type { Room, Actor, Target };
enum depend_type { ReqIntel, ReqStrength, ReqDexterity, ReqConstitution, 
		   ReqHealth, ReqMaxHealth, ReqEndurance, ReqMagic, 
		   ReqWisdom, ReqCharisma, MustHaveItem };

struct dependency {
	depend_type the_type;
	int			num_value;
	Strings     str_value;
	dependency  *next_depend;
};

class Ability : public Entity {
 public:

   Ability();
   virtual ~Ability();

   char *get_acting_str(abil_str_type the_type);
   int set_acting_str(abil_str_type the_type, char *the_string);

   char *get_success_str(abil_str_type the_type);
   int set_success_str(abil_str_type the_type, char *the_string);

   char *get_failure_str(abil_str_type the_type);
   int set_failure_str(abil_str_type the_type, char *the_string);

   char *get_items_needed();
   void set_items_needed(char *the_string);

   char *get_succ_trig();
   void set_succ_trig(char *the_string);

   char *get_fail_trig();
   void set_fail_trig(char *the_string);

   char *get_attempt_trig();
   void set_attempt_trig(char *the_string);

   void set_drain(int new_drain);
   int get_drain();

   char *get_special_name();
   void set_special_name(char *the_string);

   int set_attrib_succtrig(Parse *the_parsed, Builder *the_builder);
   int set_attrib_failtrig(Parse *the_parsed, Builder *the_builder);
   int set_attrib_attempttrig(Parse *the_parsed, Builder *the_builder);

   int read_ability_attrib(FILE *read_file, ErrLog *error_log, 
                                                          int build_format);

   int set_attrib_acting(abil_str_type message_to, Builder *the_builder);
   int set_attrib_success(abil_str_type message_to, Builder *the_builder);
   int set_attrib_failure(abil_str_type message_to, Builder *the_builder);
   int set_attrib_itemsneeded(Parse *the_parsed, Builder *the_builder);
   int set_attrib_drain(Parse *the_parsed, Builder *the_builder);
   int set_attrib_specials(Parse *the_parsed, Builder *the_builder);
   
   int set_attrib_abil(Builder *the_builder, Parse *the_parsed);

   int write_ability_attrib(FILE *the_file);

   int add_dep_item(dependency *new_item);
   int add_dependency(depend_type the_type, char *the_val);
   int add_dependency(depend_type the_type, int the_val);
   int add_dependency(char *the_type, char *the_val);
   int add_dependency(char *the_type, int the_val);
   char *get_dep_str_value(depend_type the_type);
   int get_dep_int_value(depend_type the_type);
   int set_dep_str_value(depend_type the_type, char *the_str);
   int set_dep_int_value(depend_type the_type, int the_val);
   int set_dep_str_value(char *the_type, char *the_str);
   int set_dep_int_value(char *the_type, int the_val);
   int del_dependency(depend_type the_type);
   int del_dependency(char *the_type);
   int has_dependency(depend_type the_type);
   int copy_dependencies(dependency *the_list);
   dependency *get_dependency_list();
   int copy_ability_attrib(Ability *copy_from);
   int test_success(Individual *the_user, int difficulty);
   int get_mem_size_ability();

   int use_ability(Individual *user, MudObject *target, char *targ_name);
   virtual int check_usage(Individual *user, MudObject *target);

 protected:
   dependency *depend_list;

 private:

 
   // Strings to display when the ability is attempted
   Strings acting_room;    // To the room the actor is in
   Strings acting_actor;   // To the actor
   Strings acting_target;  // To the target
 
   // Strings to display if the ability was a success
   Strings success_room;
   Strings success_actor;
   Strings success_target;

   // Strings to display if the ability failed
   Strings failure_room;
   Strings failure_actor;
   Strings failure_target;

   Strings special_name;    // Special to execute on success

   Strings attempt_trigger; // Search for specials with these triggers on
                            // when the player attempts the ability
   Strings success_trigger; // Search for specials with these triggers on
                            // success in the target
   Strings failed_trigger;  // Search for specials with these triggers on
                            // failure in the target

   int     drain;          // How much this drains the user
                           // Drains endurance for skills
                           // Drains energy for spells

};

#endif
