#ifndef _LOCATION_H
#define _LOCATION_H

#include <stdio.h>
#include "mudobject.h"
#include "strings.h"
#include "flags.h"
#include "parse.h"
#include "inp_handler.h"

class Player;
class Builder;

#define NORTH     0
#define SOUTH     1
#define EAST      2
#define WEST      3
#define UP        4
#define DOWN      5
#define NORTHEAST 6
#define NORTHWEST 7
#define SOUTHEAST 8
#define SOUTHWEST 9


enum terrain_type {Forest, Jungle,   SandDesert, RockDesert, Plains, 
                   Tundra, SnowField, Icesheet,  Hills,      Mountains,  
		   HighMountains,     Swamp,     Bog,        ThinForest,     
		   ThickForest,       City,      Ocean,      Lake,      
		   River,             PavedRoad, DirtRoad,   Enclosure};

enum light_type { FullDark, Dark, Shady, Average, Bright, Blinding };

#define CANT_SEE 0
#define CAN_SEE  1
#define SEND_ALL 2
                   
/* Input handler functions*/
int confirm_assoc_replace(MudObject *the_user, char *the_input);
int replace_exit(Inp_Handler *the_handler, char *builder_name, 
               char *the_exit, char *reverse_loc, Strings *return_loc);

class Location : public MudObject
{
public:

   Location(char *the_name, char *the_area);
   virtual ~Location();
   int set_exit(int the_dir, char *the_loc);
   Location *get_exit(int the_dir, char *the_area, int *results);
   int show_location(Player *the_player, int brief);
   int show_exits(Player *the_player);
   int send_location(char *the_string, Individual *not_this);
   int send_location(char *the_string, Individual *not_this, int can_see);
   int send_location(char *the_string, Individual *not_this, Individual *or_this);
   int send_location(char *the_string, Individual *not_this, 
                                         Individual *or_this, int can_see);
   int is_same(Location *the_loc);
   int list_individuals(Player *the_player);
   int list_immobile(Player *the_player);
   int list_objects(Player *the_player);
   virtual void describe(Builder *the_builder);
   virtual void describe(Player *the_player);
   virtual void write_object(FILE *the_file, int build_format);
   virtual int set_attrib(Builder *the_builder, Parse *the_parsed);
   virtual int copy_object(Entity *copy_obj);

   virtual int  set_title(char *the_title);
   char *get_exit(int the_dir);
   Location *get_custom_exit(char *the_dir, char *the_area, int *results);

   Location *operator = (Location *copy_from); 
   int read_location_attrib(FILE *read_file, char *areaname, 
                                                       ErrLog *error_log);   
   void  display_attrib();
   Flags *get_locflags();
   int   is_lit(void);
   int   is_lit(Individual *the_ind);
   char  *get_random_exit(Strings *holder_str);
   int   set_attrib_extra_desc(Builder *the_builder, int the_desc);
   int   set_attrib_smell(Builder *the_builder);
   int   set_attrib_listen(Builder *the_builder);
   char  *get_desc();
   char  *get_desc(int the_num);
   void  set_desc(int the_num, char *the_str);
   char  *get_listen();
   void  set_listen(char *the_str);
   char  *get_smell();
   void  set_smell(char *the_str);
   int   get_room_size();
   void  set_room_size(int new_size);
   terrain_type get_terrain();
   void  set_terrain(terrain_type new_terrain);
   light_type get_lighting();
   void  set_lighting(light_type new_lighting);
   int   list_terrain_types(Builder *the_builder);
   int   list_lighting_types(Builder *the_builder);
   float get_terrain_mult();
   
   int   apply_special(Individual *the_user, Specials *the_special, 
                                                int distance, int from_dir);
   int   cleanup_marks(int distance, int from_dir);

   char *get_extra_dir();
   void set_extra_dir(char *the_str);
   int dir_to_num(char *the_dir);
   int short_dir_to_num(char *the_dir);
   virtual int get_mem_size();
   virtual int get_mem_size_dynamic();

private:

   int assign_exit(char **the_exit, char *the_loc);
   int show_exit(Player *the_player, Strings *the_exit, int exitname);
   int show_extra_exits(Player *the_player, int full_format, 
                                       Strings *cur_str, int first);

   Location *xget_exit(char *the_exit, char *the_area, int *results);
   int      auto_associate(Builder *the_builder, int the_exit, char *new_loc);

   Flags        *loc_flags;

   Strings      dir[10];
   Strings      extra_dir;

   Strings      extra_desc[2];
   Strings      listen;
   Strings      smell;

   int          room_size;
   terrain_type the_terrain;
   light_type   the_lighting;  

   // This marker is mainly used for search algorithms.  You must remember
   // to reset it when your search is done or big problems when the next
   // search occurs and gets confused, producing bogus results.  You can
   // use cleanup_marks to set them back to 0, but it must be set to 1, this
   // is so someone can leave some marked > 1 if they see a need
   int          marked; 
}; 

#endif
