#ifndef _WEARABLE_H
#define _WEARABLE_H

#include "strings.h"
#include "moveable.h"
#include "builder.h"


class Wearable : public Moveable
{
public:

   Wearable(char *the_name, char *the_area);
   virtual ~Wearable();

   virtual void write_object(FILE *the_file, int build_format);
   virtual void describe(Builder *the_builder);
   virtual void describe(Player *the_player);
   virtual int set_attrib(Builder *the_builder, Parse *the_parsed);
   virtual int copy_object(Entity *copy_obj);

   int      copy_wearable(Wearable *copy_from);
   Wearable *operator = (Wearable *copy_from);

   Flags    *get_wearflags(void);
   int      get_armor();
   void     set_armor(int the_num);

   int      set_attrib_wearflags(Parse *the_parsed, Builder *the_builder);
   int      read_wearable_attrib(FILE *read_file, ErrLog *error_log);
   virtual  int get_mem_size();
   virtual  int get_mem_size_dynamic();

 private:

   Wearable();

   Flags *wear_flags;
   int   armor;

};

#endif

