// GameTimer.cpp: implementation of the CGameTimer class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "aime_w32.h"
#include "GameTimer.h"
#include "global.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CGameTimer::CGameTimer()
{
	input_polls = 0;
	initial_time.GetCurrentTime();
    last_heal_players = last_heal_mobiles = last_level = 
                         last_magic_players = last_endur_players = 0;
	last_second = 0;
}

CGameTimer::~CGameTimer()
{

}

BOOL CGameTimer::handle_timer()
{
	// If it is time to cycle the game (each second)
	if (the_config.pollspersec <= input_polls)
	{
		input_polls = 0;
		mainstruct->cycle_world();
	}

	mainstruct->check_players();
	mainstruct->check_builders();
	handle_events();
	mainstruct->handle_quits();
	input_polls++;
	return TRUE;
}

int CGameTimer::init_times()
{
	
	return 1;
}


/***********************************************************************
 ** plr_timesincehealed - the seconds since the last player heal
 **
 **
 ***********************************************************************/

time_t CGameTimer::plr_TimeSinceHealed()
{
   if (!last_heal_players)
      return the_config.secs_player_heal;

   return (time(0) - last_heal_players);
}


/***********************************************************************
 ** mob_timesincehealed - the seconds since the last mobile heal
 **
 **
 ***********************************************************************/

time_t CGameTimer::mob_TimeSinceHealed()
{
   if (!last_heal_mobiles)
      return the_config.secs_mobile_heal;

   return (time(0) - last_heal_mobiles);
}


/***********************************************************************
 ** plr_timesinceendur - the seconds since the last player endurance up
 **
 **
 ***********************************************************************/

time_t CGameTimer::plr_TimeSinceEndur()
{
   if (!last_endur_players)
      return the_config.secs_player_endur;

   return (time(0) - last_endur_players);
}


/***********************************************************************
 ** plr_timesincelevel - the seconds since the last level upgrade check
 **
 **
 ***********************************************************************/

time_t CGameTimer::plr_TimeSinceLevel()
{
   if (!last_level)
      return the_config.secs_level_check;

   return (time(0) - last_level);
}


/***********************************************************************
 ** plr_timesincemagic - the seconds since the last player magic up
 **
 **
 ***********************************************************************/

time_t CGameTimer::plr_TimeSinceMagic()
{
   if (!last_magic_players)
      return the_config.secs_player_magic;

   return (time(0) - last_magic_players);
}


/***********************************************************************
 ** handle_events - handles any events that need to be executed right
 **                 now
 **
 ** Parameters: None
 **
 ** Returns: 1 for success, -1 for failure
 **
 ***********************************************************************/

int CGameTimer::handle_events()
{
   float time_num[5] = {
      ( float )1,
      ( float )0.1,
      ( float )0.3,
      ( float )0.55,
      ( float ).65
   };
   
   char *time_change[5] = {
          "The sky begins to lighten with the coming of the sun.\n",
          "The sun rises above the horizon.\n",
          "The sun has peaked in the sky.\n",
          "The sun disappears beneath the horizon.\n",
          "The last bit of light vanishes, leaving a dark sky.\n"};


   if (time(0) == last_second)
	   return 0;
		  
   /* a new second is upon us, handle second events first */
   mainstruct->cycle_world();
   last_second = time(0);

   /* next handle possible time of day progressions */
   if ((last_second - start_day) > 
       (time_num[mainstruct->get_tod()] * the_config.secs_in_day))
   {
      mainstruct->send_all_outside(time_change[mainstruct->get_tod()]);
      mainstruct->increment_tod();
      if (mainstruct->get_tod() == Dawn)
         start_day = last_second;   
   }

   /* reset these heal times, since we probably already healed */
   if ((time(0) - last_heal_players) >= the_config.secs_player_heal)
	   last_heal_players = time(0);

   if ((time(0) - last_heal_mobiles) >= the_config.secs_mobile_heal)
      last_heal_mobiles = time(0);

   if ((time(0) - last_magic_players) >= the_config.secs_player_magic)
      last_magic_players = time(0);

   if ((time(0) - last_endur_players) >= the_config.secs_player_endur)
      last_endur_players = time(0);

   if ((time(0) - last_level) >= the_config.secs_level_check)
      last_level = time(0);


   return 1;
}


/***********************************************************************
 ** set_tod_time - sets the appropriate time for tod if we are manually
 **                changing tod, so it doesn't go back to where it was
 **
 ** Parameters: the_time - the time of day we are setting it to
 **
 ***********************************************************************/

void CGameTimer::set_tod_time(TimeOfDay the_time)
{
   float time_num[5] = {
      ( float )1,
      ( float )0.1,
      ( float )0.3,
      ( float )0.55,
      ( float ).65
   };
   
   long  span;
   int   new_time;

   new_time = ((int) the_time) - 1;
   if (new_time == -1)
      new_time = 4; 
   span = (long) (time_num[new_time] * the_config.secs_in_day);

   start_day = last_second - span;
}
