/*
    This file is part of AirSnort.

    AirSnort is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    AirSnort is distributed in the hope that it will be useful,
      but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with AirSnort; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <semaphore.h>
#include "Packet.h"
#include "crack.h"

void enqueuePacket(CrackNode *ap, Packet *p) {
   sem_wait(&(ap->pktSem));
   p->next = ap->queue;
   ap->queue = p;
   sem_post(&(ap->pktSem));
}

Packet *dequeuePacket(CrackNode *ap) {
   Packet *result;
   sem_wait(&(ap->pktSem));
   result = ap->queue;
   if (result) {
      ap->queue = result->next;
      result->next = NULL;
   }
   sem_post(&(ap->pktSem));
   return result;
}
