// Copyright 1999-2020 - Universit de Strasbourg/CNRS
// The Aladin Desktop program is developped by the Centre de Donnes
// astronomiques de Strasbourgs (CDS).
// The Aladin Desktop program is distributed under the terms
// of the GNU General Public License version 3.
//
//This file is part of Aladin Desktop.
//
//    Aladin Desktop is free software: you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    Aladin Desktop is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    The GNU General Public License is available in COPYING file
//    along with Aladin Desktop.
//

package cds.aladin;

import java.util.Iterator;

import cds.moc.TMoc;

/** Generation d'un plan TMOC  partir d'une liste de plans (Catalogue) 
 * @author P.Fernique [CDS]
 * @version 1.0 - avril 2018 - cration
 */
public class PlanTMocGen extends PlanTMoc {
   
   private Plan [] p;       // Liste des plans  ajouter dans le TMOC
   private double duration; // Pour un plan catalogue, dureen seconde  partir de l'poque initiale (0 sinon)
   private int order;         // Rsolution (ordre) demande
   
   private double gapPourcent;  // Pourcentage de progression par plan (100 = tout est termin)
   
   protected PlanTMocGen(Aladin aladin,String label,Plan[] p,int order,double duration) {
      super(aladin,(MyInputStream)null,label);
      this.c=null;
      this.p = p;
      this.order=order;
      this.duration=duration;
      
      pourcent=0;
      gapPourcent = 100/p.length;
      
      suiteSpecific();
      threading();
      log();
   }
   
   protected void launchLoading() {}
   
   // Ajout d'un plan catalogue au moc en cours de construction
   private void addMocFromCatalog(Plan p1,double duration) {
      Iterator<Obj> it = p1.iterator();
      int m= p1.getCounts();
      double incrPourcent = gapPourcent/m;
      while( it.hasNext() ) {
         Obj o = it.next();
         if( !(o instanceof Position) ) continue;
         if( m<100 ) pourcent+=incrPourcent;
         try {
            double jdtime = ((Position)o).jdtime;
            if( Double.isNaN( jdtime ) ) continue;
            ((TMoc)moc).add(jdtime, jdtime+ duration/86400.);
         } catch( Exception e ) {
            if( aladin.levelTrace>=3 ) e.printStackTrace();
         }
      }
      try {
         moc.toMocSet();
      } catch( Exception e ) {
         if( aladin.levelTrace>=3 ) e.printStackTrace();
      }
   }


   protected boolean waitForPlan() {
      try {
         moc = new TMoc();
         if( order!=-1) moc.setMocOrder(order);
         for( Plan p1 : p ) {
            if( p1.isCatalogTime() ) {
               if( c==null ) {
                  c = p1.c.darker();
                  System.out.println("couleur="+c);
               }
               addMocFromCatalog(p1,duration);
            }
         }
      } catch( Exception e ) {
         error=e.getMessage();
         if( aladin.levelTrace>=3 ) e.printStackTrace();
         flagProcessing=false;
         return false;
      }
      flagProcessing=false;
      if( moc.getSize()==0 ) error="Empty TMOC";
      flagOk=true;
      return true;
   }
   

      
}

