#!/usr/bin/python
#encoding: utf-8

from distutils.core import setup
import glob
from distutils.command.install import install as _install
from distutils.command.install_data import install_data as _install_data
from distutils.command.build import build as _build
from distutils import cmd
import msgfmt
import os
import shutil

AppName = "alarm-clock"
FullName = "Alarm Clock"
Version = "0.9.11"
Author = "Tomasz Sałaciński"
AuthorEmail = "tsalacinski@gmail.com"
Description = "Alarm Clock for GTK written in Python"
Url = "http://www.alarm-clock.54.pl"
License = "GPLv2"

Data = [('share/alarm-clock/glade',  ['glade/main.glade']),
        ('share/alarm-clock/scalable', glob.glob('scalable/*.svg')),
		('share/alarm-clock/sound', ['sound/ring.wav']),
        ('share/pixmaps' , ['scalable/alarm-clock.svg']),
        ('share/applications' , ['alarm-clock.desktop'])]


class build_trans(cmd.Command):
    description = 'Compile .po files into .mo files'
    
    def initialize_options(self):
        pass

    def finalize_options(self):        
        pass

    def run(self):
        po_dir = os.path.join(os.path.dirname(os.curdir), 'po')
        for path, names, filenames in os.walk(po_dir):
            for f in filenames:
                if f.endswith('.po'):
                    lang = f[:len(f) - 3]
                    src = os.path.join(path, f)
                    dest_path = os.path.join('build', 'locale', lang, 'LC_MESSAGES')
                    dest = os.path.join(dest_path, 'alarm-clock.mo')
                    if not os.path.exists(dest_path):
                        os.makedirs(dest_path)
                    if not os.path.exists(dest):
                        print 'Compiling %s' % src
                        msgfmt.make(src, dest)
                    else:
                        src_mtime = os.stat(src)[8]
                        dest_mtime = os.stat(dest)[8]
                        if src_mtime > dest_mtime:
                            print 'Compiling %s' % src
                            msgfmt.make(src, dest)

# Thanks to Iain Nicol for code to save the location for installed prefix
# At runtime, we need to know where we installed the data to.

class write_data_install_path(cmd.Command):
    description = 'saves the data installation path for access at runtime'
    
    def initialize_options(self):
        self.prefix = None
        self.lib_build_dir = None

    def finalize_options(self):
        self.set_undefined_options('install',
            ('prefix', 'prefix')
        )
        self.set_undefined_options('build',
            ('build_lib', 'lib_build_dir')
        )

    def run(self):
        conf_filename = os.path.join(self.lib_build_dir,
            'alarmclock', 'Prefix.py')

        conf_file = open(conf_filename, 'r')
        data = conf_file.read()
        conf_file.close()
        data = data.replace('@datadir@', self.prefix)
        conf_file = open(conf_filename, 'w')
        conf_file.write(data)
        conf_file.close()

    def get_outputs(self): return []



class unwrite_data_install_path(cmd.Command):
    description = 'undoes write_data_install_path'

    def initialize_options(self):
        self.lib_build_dir = None

    def finalize_options(self):        
        self.set_undefined_options('build',
            ('build_lib', 'lib_build_dir')
        )

    def run(self):
        dest = os.path.join(self.lib_build_dir,
            'alarmclock', 'Prefix.py')
        shutil.copyfile('alarm-clock/Prefix.py', dest)

    def get_outputs(self): return []



class install_data(_install_data):
    def run(self):
		for lang in os.listdir('build/locale/'):
			lang_dir = os.path.join('share', 'locale', lang, 'LC_MESSAGES')
			lang_file = os.path.join('build', 'locale', lang, 'LC_MESSAGES', 'alarm-clock.mo')
			self.data_files.append( (lang_dir, [lang_file]) )
		_install_data.run(self)

class build(_build):
    sub_commands = _build.sub_commands + [('build_trans', None)]
    def run(self):
        _build.run(self)

class install(_install):
    sub_commands = [('write_data_install_path', None)] + \
        _install.sub_commands + [('unwrite_data_install_path', None)]
    def run(self):
        _install.run(self)
        os.system("chmod 777 build -R")
        os.remove("msgfmt.pyc")


cmdline = {	'build': build,
			'install': install,
			'build_trans': build_trans,
			'install_data': install_data,
			'write_data_install_path': write_data_install_path,
			'unwrite_data_install_path': unwrite_data_install_path, }


setup(name=AppName, fullname=FullName, version=Version,
    author=Author, author_email=AuthorEmail, description=Description,
    url=Url, license=License,
    scripts=["scripts/alarm-clock"],
    packages=['alarmclock'],
    package_dir = {'alarmclock': 'alarm-clock'},
	data_files=Data,
	cmdclass=cmdline
)

