#
# Copyright 2001 by Object Craft P/L, Melbourne, Australia.
#
# LICENCE - see LICENCE file distributed with this software for details.
#
# 
# Test environment settings.
#
# $Id: env.py,v 1.5 2002/07/30 07:33:51 andrewm Exp $

import unittest
import albatross
import albatross_test

import os

class EnvCase(albatross_test.AlbatrossTestCase):
    template_dir = "env"

    # overload html_test() to drop environment into local context
    def html_test(self, template_file, expect):
        self.ctx.locals.env = os.environ
        albatross_test.AlbatrossTestCase.html_test(self, template_file, expect)

    def check_home(self):
        self.html_test("home.html", os.environ['HOME'])


class EnvSuite(unittest.TestSuite):
    test_list = (
        "check_home",
    )
    def __init__(self):
        unittest.TestSuite.__init__(self, map(EnvCase, self.test_list))

def suite():
    return EnvSuite()

if __name__ == '__main__':
    unittest.main(defaultTest='suite')
