#
# Copyright 2003 by Object Craft P/L, Melbourne, Australia.
#
# LICENCE - see LICENCE file distributed with this software for details.
#
# AUTHOR(S)
#       Matt Goodall <matt AT pollenation DOT net>

import fcgi
from albatross import cgiapp


class Request(cgiapp.Request):

    def __init__(self, fields = None):
        self.__fcgi = fcgi.FCGI()
        if fields is None:
            fields = self.__fcgi.getFieldStorage()
        cgiapp.Request.__init__(self, fields)

    def get_uri(self):
        return self.__fcgi.env.get('REQUEST_URI')

    def get_method(self):
        return self.__fcgi.env.get('REQUEST_METHOD')

    def get_path_info(self):
        return self.__fcgi.env.get('PATH_INFO')

    def get_servername(self):
        return self.__fcgi.env.get('HTTP_HOST')

    def get_header(self, name):
        env_name = 'HTTP_' + name.upper().replace('-', '_')
        return self.__fcgi.env.get(env_name)

    def return_code(self):
        self.__fcgi.Finish()

def running():
    return fcgi.isFCGI()
