#
# Copyright 2001 by Object Craft P/L, Melbourne, Australia.
#
# LICENCE - see LICENCE file distributed with this software for details.
#
# 
# Build and test all listed modules.
#
# The module files must have a function "suite" which returns
# an instance of unittest.TestSuite or unittest.TestCase.
#
# $Id: __init__.py 6162 2004-01-14 04:22:40Z andrewm $

import unittest

class AllTestSuite(unittest.TestSuite):
    # add modules with tests here
    all_tests = [
    	'pagemodule',
        'uriparse',
    ]
    def __init__(self):
        unittest.TestSuite.__init__(self)
        for module_name in self.all_tests:
            module = __import__(module_name, globals())
            self.addTest(module.suite())

def suite():
    return AllTestSuite()

if __name__ == '__main__':
    unittest.main(defaultTest='AllTestSuite')
