//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

//Systemwide includes
#include <qstring.h>

//Projectwide includes
#include "recentAlbums.h"

#define MAX_RECENT_ALBUMS 9

//==============================================
RecentAlbums::RecentAlbums()
{
  maxItems = MAX_RECENT_ALBUMS;
}
//==============================================
void RecentAlbums::clearList()
{
  albumNames.clear();
  albumLocations.clear();
  albumPhotoCounts.clear();
}
//==============================================
int RecentAlbums::numEntries()
{
  return albumNames.count();
}
//==============================================
int RecentAlbums::getMaxItems()
{
  return maxItems;
}
//==============================================
void RecentAlbums::getEntry ( int index, QString& name, QString& location, QString& photoCount )
{
  name       = *( albumNames.at       (index) );
  location   = *( albumLocations.at   (index) );
  photoCount = *( albumPhotoCounts.at (index) );  
}
//==============================================
void RecentAlbums::insertEntry ( QString name, 
                                 QString location, 
                                 QString photos, 
                                 bool insertAtBack )
{
  //items are inserted at back during intialization of list when
  //starting up the program. no duplicates should exist so no checking is performed
  if(insertAtBack || albumNames.count() == 0)
  {
    albumNames.append      ( name     );
    albumLocations.append  ( location );
    albumPhotoCounts.append( photos   ); 
  }
  //items are inserted at the front of the list when either:
  //1.) a new album is saved or
  //2.) an album is opened.
  //the list must then be checked for duplicates and any such duplicates should be removed
  else
  {
    //prepend item
    QStringList::Iterator namesIterator       = ++albumNames.prepend       ( name     );
    QStringList::Iterator locationsIterator   = ++albumLocations.prepend   ( location );
    QStringList::Iterator photoCountsIterator = ++albumPhotoCounts.prepend ( photos   );

    //search list for dupes
    while( true )
    {
      //if location matches remove item
      if( location.compare(*locationsIterator) == 0 )
      {
        albumNames.remove      ( namesIterator       );
        albumLocations.remove  ( locationsIterator   );
        albumPhotoCounts.remove( photoCountsIterator );
        break;
      }

      //end of list? stop
      if( namesIterator == albumNames.end() ) break;
      
      //move to next item.
      namesIterator++;
      locationsIterator++;
      photoCountsIterator++; 
    }

  }//end else

  //truncate list as necessary
  while(albumNames.count() > maxItems )
  {
    albumNames.remove( albumNames.last() );
    albumLocations.remove( albumLocations.last() );
    albumPhotoCounts.remove( albumPhotoCounts.last() );
  }  
}
//==============================================
