//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef BACKEND_TOOLS_FILETOOLS_H
#define BACKEND_TOOLS_FILETOOLS_H

//--------------------
//forward declarations
//--------------------
class QString;

//Moves a file from one location to another
bool moveFile( QString oldName, QString newName);

///Copies a file from one location to another
bool copyFile(QString oldName, QString newName);

///Replaces invalid characters in filenames with valid ones
QString fixFilename( QString filename );

//PLATFORM_SPECIFIC_CODE
///Folder types for getWindowsFolderLocation
#if defined(Q_OS_WIN)
typedef enum
{
  APPLICATION_DATA,                // {user}/Application Data
  LOCAL_SETTINGS_APPLICATION_DATA, //{user}/Local Settings/Application Data
} FOLDER_TYPE;
  
///Obtains the path to windows folder
bool getWindowsFolderLocation(FOLDER_TYPE type, QString& path);
#endif

#endif //BACKEND_TOOLS_FILETOOLS_H
