//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

//Systemwide includes
#include <qpixmap.h>
#include <qstring.h>
#include <qpainter.h>
#include <qiconview.h>

//Projectwide includes
#include "groupIcon.h"
#include "groupsWidget.h"

//==============================================
GroupIcon::GroupIcon( QIconView* parent, QPixmap icon, 
                      QString text, QWidget* settingsWidget) :
                      QIconViewItem(parent, text, icon)
{
  this->parent = parent;
  this->settingsWidget = settingsWidget;
  mousedOver = false;
  
  //initialize item rectangle
  initializeItemRect();
}
//==============================================
void GroupIcon::paintItem( QPainter* p, const QColorGroup&)
{
  p->save();
  QRect r = rect();

  //if selected paint dark blue background and outline
  if(isSelected())
  {
    //Draw Selected Color (dark blue)
    p->fillRect( r, QColor(193, 210, 238) );

    //draw selection rectangle (darker blue)
    p->setPen( QColor(49, 106, 197) );
    p->drawRect(r);
  }
  //else if pseudo selected paint ligher blue background with outline
  else if(mousedOver)
  {
    //Draw Pseudo Selected Color (light blue)
    p->fillRect( r, QColor(224, 232, 246) );

    //draw selection rectangle (darker blue)
    p->setPen( QColor(152, 180, 226) );
    p->drawRect(r);
  }

  p->restore();

  p->drawPixmap( x()+3 , y() + ( height() - pixmap()->height() ) / 2, *pixmap());

  int align = AlignLeft | WordBreak | BreakAnywhere;
  p->drawText( textRect( FALSE ), align, text());
}
//==============================================
void GroupIcon::paintFocus( QPainter*, const QColorGroup&) { }
//==============================================
QWidget* GroupIcon::getSettingsWidget() { return settingsWidget; }
//==============================================
void GroupIcon::setMousedOver(bool val) { mousedOver = val; }
//==============================================
void GroupIcon::initializeItemRect()
{
  //reset pixmap rect
  QRect pr = pixmapRect();
  int prWidth  = pr.width();
  int prHeight = pr.height();
  pr.setTopLeft( QPoint(3,3) );
  pr.setBottomRight( QPoint(pr.left()+prWidth, pr.top()+prHeight) );
  setPixmapRect( pr );
  
  //reset text rect
  int textWidth = ((GroupsWidget*)parent)->getTextWidth();
  QRect tr = textRect();
  tr.setTop( pixmapRect().top() );
  tr.setBottom( pixmapRect().bottom() );
  tr.setLeft( pixmapRect().right() + 2 );
  tr.setRight( tr.left() + textWidth );
  setTextRect( tr );
  
  //reset item rect using pixmap and text rect dimensions
  int itemW = 3 + pixmapRect().width() + (tr.left() - pr.right()) + textRect().width() + 3;
  int itemH = 3 + pixmapRect().height() + 3;
  setItemRect( QRect( pixmapRect().left() - 3, pixmapRect().top() - 3, itemW, itemH ) );
}
//==============================================
