//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef GUI_DIALOGS_ADDPHOTOSDIALOG_H
#define GUI_DIALOGS_ADDPHOTOSDIALOG_H

//--------------------
//forward declarations
class QGridLayout;
class QFileDialog;
class QCheckBox;
class QLabel;
//--------------------

#include <qfiledialog.h>
#include <qmutex.h>
#include <qthread.h>
class FilePreview;
class GeneratePreviewThread;

//================================
class GeneratePreviewThread : public QThread
{
public:
  GeneratePreviewThread( FilePreview* previewWidget );
  void start( QString filename);
  virtual void run();
  //--------------
private:
  ///current file being processed
  QString filename;
  
  ///handle on preview widget necessary for posting
  ///an update event once the current file has been processed
  FilePreview* previewWidget;

  ///is the worker thread currently generating a file preview?
  bool updating;

  ///next file to be processed by worker thread
  QString queue;
  
  ///locking mutex - necessary to prevent multiple threads from
  ///accessing the updating bool or queue variable simultaniously
  QMutex lockingMutex;
};
//==============================================
class FilePreview : public QWidget, public QFilePreview
{
public:
  FilePreview( QWidget* parent=0 );
  ~FilePreview();
  QSize minimumSizeHint () const;

  ///declared to make base class happy. we'll use an updatePreview function instead
  void previewUrl( const QUrl& ) {}
  
  ///call this function to update the file preview
  void updatePreview( const QString& path );
    
protected:
  ///handle update events that come from the GeneratePreviewThread
  void customEvent( QCustomEvent * e );
  
private:
  ///preview of last selected file
  QLabel* filePreview;
  
  ///details about last selected file
  QLabel* fileDetails;
  
  ///a worker thread that actually generates the file 
  ///preview image and details information
  ///that is displayed.
  GeneratePreviewThread* generatorThread;
};
//=====================================
/*! \brief Simple dialog for browsing and select photos to add to a subalbum.
 */
//=====================================
class AddPhotosDialog : public QFileDialog
{
Q_OBJECT

public:
  AddPhotosDialog(QString path, QWidget *parent=0, const char* name=0);
  
  ///returns the list of selected filenames, while setting 
  ///setDescritions to the state the checkbox was left in.
  QStringList getFilenames(bool& setDescriptions);
//----------------------
private:
  ///Checkbox asking if filenames should be used to set image descriptions
  QCheckBox* setDescriptions;
  
  ///Used to preview selected files
  FilePreview* filePreview;
//----------------------
private slots:  
  ///handle the user selecting items by updating the file preview fields
  void updatePreview(const QString& filename);
//----------------------
};
//======================

#endif //GUI_DIALOGS_ADDPHOTOSDIALOG_H
