# ----------------------------------------------------------------------------
# - aleph-docs                                                               -
# - aleph documentation rule makefile configuration                          -
# ----------------------------------------------------------------------------
# - This program is  free software;  you can  redistribute it and/or  modify -
# - it provided that this copyright notice is kept intact.                   -
# -                                                                          -
# - This  program  is  distributed in the hope  that it  will be useful, but -
# - without  any   warranty;  without  even   the   implied    warranty   of -
# - merchantability  or fitness for a particular purpose. In not event shall -
# - the copyright holder be  liable for  any direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.      -
# ----------------------------------------------------------------------------
# - copyright (c) 1999-2001 amaury darsch                                    -
# ----------------------------------------------------------------------------

# ----------------------------------------------------------------------------
# - doc definition engine                                                    -
# ----------------------------------------------------------------------------

LATEX		= $(CNFDIR)/bin/aleph-latex
DVIPS		= dvips
BIBTEX		= bibtex
PDFTEX		= pdflatex
MKINDEX		= makeindex

# ----------------------------------------------------------------------------
# - documentation definitions                                                -
# ----------------------------------------------------------------------------

DOCETC		= $(TEXDIR)/etc
SRCTEX		= $(wildcard *.tex)

TEXMAN		= $(MANUAL).tex
DVIMAN		= $(MANUAL).dvi
EPSMAN		= $(MANUAL).ps
PDFMAN		= $(MANUAL).pdf

# ----------------------------------------------------------------------------
# - manual rules                                                             -
# ----------------------------------------------------------------------------

ifneq ($(ETCLNK),)
$(ETCLNK):
	@$(RM) $(ETCLNK)
	@(for f in $(ETCLNK); do ($(LN) $(DOCETC)/$$f $$f); done)
endif

$(EPSMAN): $(SRCTEX) $(ETCLNK)
	@$(LATEX) $(MANUAL)
	@$(DVIPS) -o $(EPSMAN) $(DVIMAN)
	@$(RM)    *.log *.aux *.toc *.idx *.ilg *.ind

epsman: $(EPSMAN)
.PHONY: epsman

$(PDFMAN): $(SRCTEX) $(ETCLNK)
	@$(LATEX)  $(MANUAL)
	@$(PDFTEX) $(TEXMAN)
	@$(PDFTEX) $(TEXMAN)
	@$(RM)     *.log *.aux *.toc *.idx *.ilg *.ind

pdfman: $(PDFMAN)
.PHONY: pdfman

# ----------------------------------------------------------------------------
# - generic clean                                                            -
# ----------------------------------------------------------------------------

clean::
	@$(RM) *.o *.d *~ core *.core *.so *.so.* *.a *.bb *.bbg *.da
	@$(RM) *.log *.aux *.toc *.idx *.ilg *.ind *.out
	@$(RM) *.ps *.eps *.pdf *.dvi *.toc *.aux *.log gpl.tex
	@$(RM) *.idx *.ilg *.ind  *.bbl *.blg *.gz 
.PHONY: clean
