// ---------------------------------------------------------------------------
// - Libanet.cpp                                                             -
// - aleph:net library - declaration & implementation                        -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2001 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Meta.hpp"
#include "Mail.hpp"
#include "Libanet.hpp"
#include "Netcalls.hpp"
#include "Predanet.hpp"
#include "Function.hpp"
#include "TcpClient.hpp"
#include "UdpClient.hpp"
#include "Multicast.hpp"
#include "TcpServer.hpp"
#include "UdpServer.hpp"

namespace aleph {
  Object* init_aleph_net (Interp* interp, Vector* argv) {
    // make sure we are not called from something crazy
    if (interp == nilp) return nilp;
    
    // create the aleph:sys nameset
    Nameset* aset = interp->mknset ("aleph", interp->getgset ());
    Nameset* anet = interp->mknset ("net",   aset);
    
    // bind all classes in the aleph:net nameset
    anet->symcst ("Mail",          new Meta (Mail::mknew));
    anet->symcst ("Address",       new Meta (Address::mknew));
    anet->symcst ("Socket",        new Meta (Socket::meval));
    anet->symcst ("TcpSocket",     new Meta (TcpSocket::mknew));
    anet->symcst ("TcpServer",     new Meta (TcpServer::mknew));
    anet->symcst ("TcpClient",     new Meta (TcpClient::mknew));
    anet->symcst ("UdpSocket",     new Meta (UdpSocket::mknew));
    anet->symcst ("UdpServer",     new Meta (UdpServer::mknew));
    anet->symcst ("UdpClient",     new Meta (UdpClient::mknew));
    anet->symcst ("Multicast",     new Meta (Multicast::mknew));
    
    // bind all predicates in the aleph:net nameset
    anet->symcst ("mail-p",          new Function (anet_mailp));
    anet->symcst ("socket-p",        new Function (anet_socketp));
    anet->symcst ("address-p",       new Function (anet_addressp));
    anet->symcst ("datagram-p",      new Function (anet_datagramp));
    anet->symcst ("tcp-socket-p",    new Function (anet_tcpsocketp));
    anet->symcst ("udp-socket-p",    new Function (anet_udpsocketp));
    anet->symcst ("tcp-client-p",    new Function (anet_tcpclientp));
    anet->symcst ("udp-client-p",    new Function (anet_udpclientp));
    anet->symcst ("tcp-server-p",    new Function (anet_tcpserverp));
    anet->symcst ("udp-server-p",    new Function (anet_udpserverp));
    anet->symcst ("multicast-p",     new Function (anet_multicastp));
    
    // bind the network system calls
    anet->symcst ("get-loopback",    new Function (anet_getloopback));
    anet->symcst ("get-tcp-service", new Function (anet_gettcpserv));
    anet->symcst ("get-udp-service", new Function (anet_getudpserv));
    
    // not used but needed
    return nilp;
  }
}

extern "C" {
  aleph::Object* dli_aleph_net (aleph::Interp* interp, aleph::Vector* argv) {
    return init_aleph_net (interp, argv);
  }
}
