# ---------------------------------------------------------------------------
# - t_7003.als                                                              -
# - aleph:net library test module                                           -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2001 amaury darsch                                   -
# ---------------------------------------------------------------------------

# @info   udp server test module
# @author amaury darsch

# get the library
interp:library "aleph-net"
interp:library "aleph-sys"

# create a udp server and loop to accept connection
const create-udp-server nil {
  try {
    # create a udp server on port 8000
    const s (aleph:net:UdpServer 8000)
    # notify we are ready
    cv:mark
    # wait for a datagram
    const dg (s:accept)
    # reply with a greeting string 
    dg:write "hello world"
    # close this udp server
    s:close
  } (aleph:sys:exit 1)
}

# create a condition variable
const cv (Condvar)
# create the udp server in a daemon thread
daemon (create-udp-server)
# wait for the server to settle
cv:wait-unlock

# create a udp client object
const clt (aleph:net:UdpClient "localhost" 8000)
# send an empty datagram
clt:write

# read line and check greeting
const buf (clt:read 256)
assert "hello world" (buf:to-string)
clt:close
