# ----------------------------------------------------------------------------
# - aleph-docs                                                               -
# - aleph documentation rule makefile configuration                          -
# ----------------------------------------------------------------------------
# - This program is  free software;  you can  redistribute it and/or  modify -
# - it provided that this copyright notice is kept intact.                   -
# -                                                                          -
# - This  program  is  distributed in the hope  that it  will be useful, but -
# - without  any   warranty;  without  even   the   implied    warranty   of -
# - merchantability  or fitness for a particular purpose. In not event shall -
# - the copyright holder be  liable for  any direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.      -
# ----------------------------------------------------------------------------
# - copyright (c) 1999-2003 amaury darsch                                    -
# ----------------------------------------------------------------------------

# ----------------------------------------------------------------------------
# - doc definition engine                                                    -
# ----------------------------------------------------------------------------

LATEX		= $(CNFDIR)/bin/aleph-latex
DVIPS		= dvips
PS2PDF          = ps2pdf
BIBTEX		= bibtex
PDFTEX		= pdflatex
MKINDEX		= makeindex

# ----------------------------------------------------------------------------
# - documentation definitions                                                -
# ----------------------------------------------------------------------------

DOCETC		= $(TEXDIR)/etc
DOCIMG		= $(TEXDIR)/img
SRCTEX		= $(wildcard *.tex)

TEXMA4		= $(MANUAL)-A4.tex
DVIMA4		= $(MANUAL)-A4.dvi
EPSMA4		= $(MANUAL)-A4.ps
PDFMA4		= $(MANUAL)-A4.pdf

TEXMLT		= $(MANUAL)-LT.tex
DVIMLT		= $(MANUAL)-LT.dvi
EPSMLT		= $(MANUAL)-LT.ps
PDFMLT		= $(MANUAL)-LT.pdf
TEXINP		= $(TEXDIR)/etc/:$(TEXEXT)

# ----------------------------------------------------------------------------
# - manual rules                                                             -
# ----------------------------------------------------------------------------

%.pdf : %.ps
	@$(PS2PDF) $< $@

$(EPSMA4): $(SRCTEX)
	@$(LATEX) $(MANUAL) A4 $(TEXINP)
	@$(DVIPS) -t a4 -o $(EPSMA4) $(DVIMA4)
	@$(RM)    *.log *.aux *.toc *.idx *.ilg *.ind *.cb

$(EPSMLT): $(SRCTEX)
	@$(LATEX) $(MANUAL) LT $(TEXINP)
	@$(DVIPS) -t letter -o $(EPSMLT) $(DVIMLT)
	@$(RM)    *.log *.aux *.toc *.idx *.ilg *.ind *.cb

epsman: $(EPSMA4) $(EPSMLT)
.PHONY: epsman

pdfman: $(PDFMA4) $(PDFMLT) 
.PHONY: pdfman

# ----------------------------------------------------------------------------
# - generic clean                                                            -
# ----------------------------------------------------------------------------

clean::
	@$(RM) *.o *.d *~ core *.core *.so *.so.* *.a *.bb *.bbg *.da
	@$(RM) *.log *.aux *.toc *.idx *.ilg *.ind *.out
	@$(RM) *.ps *.eps *.pdf *.dvi *.toc *.aux *.log gpl.tex
	@$(RM) *.idx *.ilg *.ind  *.bbl *.blg *.gz *.cb
.PHONY: clean
