// ---------------------------------------------------------------------------
// - XHtmlPage.hpp                                                           -
// - aleph:www library - xhtml page class definition                         -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_XHTMLPAGE_HPP
#define  ALEPH_XHTMLPAGE_HPP

#ifndef  ALEPH_HTMLPAGE_HPP
#include "HtmlPage.hpp"
#endif

namespace aleph {

  /// The XHtmlPage is an extension of the HtmlPage class that provides
  /// support for the XHtml standard. XHtml differs in many way compared
  /// to regular Html. In particular, the header is completly different.
  /// @author amaury darsch

  class XHtmlPage : public HtmlPage {
  private:
    /// the xml language
    String d_lang;

  public:
    /// create an empty xhtml page
    XHtmlPage (void);

    /// @return the class name
    String repr (void) const;

    /// set the xml language
    /// @param lang the language to set
    void setlang (const String& lang);

    /// @return the xml language
    String getlang (void) const;

    /// add a page style link
    /// @param style the style to set
    void addstyle (const String& style);

    /// add a meta markup by name and content
    /// @param name the meta name to add
    /// @param content the meta content to add
    void addmeta (const String& name, const String& content);

    /// write the xhtml page to the output stream
    /// @param os the output stream
    void writepage (Output& os) const;

    /// @return a buffer containing the xhtml page
    Buffer* getbuffer (void) const;

    /// generate a new xhtml page object
    /// @param argv the argument vector
    static Object* mknew (Vector* argv);

    /// apply this xhtml page with a set of arguments and a quark
    /// @param robj  robj the current runnable
    /// @param nset  the current nameset    
    /// @param quark the quark to apply these arguments
    /// @param argv  the arguments to apply
    Object* apply (Runnable* robj, Nameset* nset, const long quark,
                   Vector* argv);

  private:
    // make the copy constructor private
    XHtmlPage (const XHtmlPage&);
    // make the assignment operator private
    XHtmlPage& operator = (const XHtmlPage&);
  };
}

#endif
