// ---------------------------------------------------------------------------
// - cdir.hpp                                                                -
// - standard system library - c directory function definition               -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_CDIR_HPP
#define  ALEPH_CDIR_HPP

#ifndef  ALEPH_CCNF_HPP
#include "ccnf.hpp"
#endif

namespace aleph {

  /// @return the root directory name
  const char* c_rootdir (void);

  /// @return the native directory separator
  const char c_dirsep (void);

  /// open a directory by name
  void* c_opendir (const char* name);

  /// get the next file name in the dirctory handle
  /// @param handle the directory handle
  char* c_readdir (void* handle);

  /// rewind a directory entry to its begining
  /// @param handle the directory handle
  void c_rewinddir (void* handle);

  /// close a directory handle
  /// @param handle the directory handle
  void c_closedir (void* handle);

  /// return the current directory name
  char* c_getcwd (void);

  /// create a directory. If the directory exists, the function succeds.
  /// @param name the directory name
  /// @return on success or false in case of error
  bool c_mkdir (const char* name);

  /// remove an empty directory
  bool c_rmdir (const char* name);

  /// extract the directory name from a path
  /// @param path the path to process
  char* c_xdir (const char* path);  

  /// extract the file name from a path
  /// @param path the path to process
  char* c_xname (const char* path);  

  /// remove the file extension from a file name
  /// @param name the original file name
  /// @return the file name without the extension
  char* c_rmext (const char* name);

  /// extract a file name extension
  /// @param name the original file name
  char* c_xext (const char* name);
}

#endif
