// ---------------------------------------------------------------------------
// - Library.hpp                                                             -
// - standard object library - dynamic library class definition              -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_LIBRARY_HPP
#define  ALEPH_LIBRARY_HPP

#ifndef  ALEPH_STRING_HPP
#include "String.hpp"
#endif

namespace aleph {

  /// The Library class is used to manipulate system shared libraries. A 
  /// library instance is created by name, and an attempt to open the shared
  /// library is done. Once the library is open, it is possible to invoke a 
  /// a system procedure with the apply method.
  /// @author amaury darsch

  class Library : public Object {
  private:
    /// the library name
    String d_name;
    /// the shared library handle
    void* p_handle;
    /// the registered library handle
    struct s_rlib* p_rlib;

  public:
    /// open a shared library by name
    /// @param name the library name
    Library (const String& name);

    /// destroy and close this shared library
    ~Library (void);

    /// @return the class name
    String repr (void) const;

    /// @return the library name
    String getname (void) const;

    /// @return a symbol by name
    void* find (const String& name) const;

    /// register a new static library by name and entry point
    static void stareg (const String& name, void* handle);

    /// initialize a dynamic library
    /// @param robj robj the current runnable
    /// @param argv the arguments for initialization
    Object* dlinit (Runnable* robj, Vector* argv);

    /// generate a new library object
    /// @param argv the argument vector
    static Object* mknew (Vector* argv);
    
  private:
    // make the copy constructor private
    Library (const Library&);
    // make the assignment operator private
    Library& operator = (const Library&);
  };
}

#endif
