/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 *  Authors: Jeffrey Stedfast <fejj@ximian.com>
 *
 *  Copyright 2003 Ximian, Inc. (www.ximian.com)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 *
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "vgskinprefs.h"


static void vg_skin_prefs_class_init (VgSkinPrefsClass *klass);
static void vg_skin_prefs_init (VgSkinPrefs *prefs);
static void vg_skin_prefs_destroy (GtkObject *obj);
static void vg_skin_prefs_finalize (GObject *obj);

static void skin_prefs_apply (VgSkinPrefs *prefs);
static void skin_prefs_get_argv (VgSkinPrefs *prefs, const char *skin, GPtrArray *argv);


static GtkVBoxClass *parent_class = NULL;


GType
vg_skin_prefs_get_type (void)
{
	static GType type = 0;
	
	if (!type) {
		static const GTypeInfo info = {
			sizeof (VgSkinPrefsClass),
			NULL, /* base_class_init */
			NULL, /* base_class_finalize */
			(GClassInitFunc) vg_skin_prefs_class_init,
			NULL, /* class_finalize */
			NULL, /* class_data */
			sizeof (VgSkinPrefs),
			0,    /* n_preallocs */
			(GInstanceInitFunc) vg_skin_prefs_init,
		};
		
		type = g_type_register_static (GTK_TYPE_VBOX, "VgSkinPrefs", &info, 0);
	}
	
	return type;
}

static void
vg_skin_prefs_class_init (VgSkinPrefsClass *klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);
	GtkObjectClass *gtk_object_class = GTK_OBJECT_CLASS (klass);
	
	parent_class = g_type_class_ref (GTK_TYPE_VBOX);
	
	object_class->finalize = vg_skin_prefs_finalize;
	gtk_object_class->destroy = vg_skin_prefs_destroy;
	
	/* virtual methods */
	klass->apply = skin_prefs_apply;
	klass->get_argv = skin_prefs_get_argv;
}

static void
vg_skin_prefs_init (VgSkinPrefs *prefs)
{
	;
}

static void
vg_skin_prefs_finalize (GObject *obj)
{
	G_OBJECT_CLASS (parent_class)->finalize (obj);
}

static void
vg_skin_prefs_destroy (GtkObject *obj)
{
	GTK_OBJECT_CLASS (parent_class)->destroy (obj);
}


static void
skin_prefs_apply (VgSkinPrefs *prefs)
{
	;
}


void
vg_skin_prefs_apply (VgSkinPrefs *prefs)
{
	g_return_if_fail (VG_IS_SKIN_PREFS (prefs));
	
	VG_SKIN_PREFS_GET_CLASS (prefs)->apply (prefs);
}


static void
skin_prefs_get_argv (VgSkinPrefs *prefs, const char *skin, GPtrArray *argv)
{
	;
}


void
vg_skin_prefs_get_argv (VgSkinPrefs *prefs, const char *skin, GPtrArray *argv)
{
	g_return_if_fail (VG_IS_SKIN_PREFS (prefs));
	g_return_if_fail (argv != NULL);
	
	VG_SKIN_PREFS_GET_CLASS (prefs)->get_argv (prefs, skin, argv);
}
