/*  EffectsWindow.cpp
 *  Copyright (C) 1998 Andy Lo A Foe <andy@alsa-project.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 
#include "EffectsWindow.h"
#include "Main.h"
#include "gladesrc.h"

extern int global_effects_show;
extern gint global_reverb_delay;
extern gint global_reverb_feedback;

void effects_scale_cb(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	GtkAdjustment *adj;
	gint *val;

	val = (gint *)data;
	
	adj = GTK_RANGE(widget)->adjustment;

	*val = (gint) adj->value;
}


void effects_delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
        gint x, y;

        gdk_window_get_origin(widget->window, &x, &y);
        if (windows_x_offset >= 0) {
                x -= windows_x_offset;
                y -= windows_y_offset;
        }	
        gtk_widget_hide(widget);
        gtk_widget_set_uposition(widget, x, y);
        global_effects_show = 0;
}


void reverb_off(GtkWidget *widget, gpointer data)
{
	GtkWidget *feedback_scale;
	GtkAdjustment *adj;

	feedback_scale = get_widget(GTK_WIDGET(data), "feedback_scale");
	adj = GTK_RANGE(feedback_scale)->adjustment;
        gtk_adjustment_set_value(adj, 0.0);
        global_reverb_feedback = 0;
}


void preset1_reverb(GtkWidget *widget, gpointer data)
{
        GtkWidget *delay_scale;
        GtkWidget *feedback_scale;
        GtkAdjustment *adj;

        delay_scale = get_widget(GTK_WIDGET(data), "delay_scale");
        feedback_scale = get_widget(GTK_WIDGET(data), "feedback_scale");

        adj = GTK_RANGE(delay_scale)->adjustment;
        gtk_adjustment_set_value(adj, 40.0);
	global_reverb_delay = 40;
        adj = GTK_RANGE(feedback_scale)->adjustment;
        gtk_adjustment_set_value(adj, 58.0);
	global_reverb_feedback = 58;

}


void preset2_reverb(GtkWidget *widget, gpointer data)
{
        GtkWidget *delay_scale;
        GtkWidget *feedback_scale;
        GtkAdjustment *adj;

        delay_scale = get_widget(GTK_WIDGET(data), "delay_scale");
        feedback_scale = get_widget(GTK_WIDGET(data), "feedback_scale");

        adj = GTK_RANGE(delay_scale)->adjustment;
        gtk_adjustment_set_value(adj, 80.0);
        global_reverb_delay = 80;
	adj = GTK_RANGE(feedback_scale)->adjustment;
        gtk_adjustment_set_value(adj, 30.0);
	global_reverb_feedback = 30;
}


void preset3_reverb(GtkWidget *widget, gpointer data)
{
        GtkWidget *delay_scale;
        GtkWidget *feedback_scale;
        GtkAdjustment *adj;

        delay_scale = get_widget(GTK_WIDGET(data), "delay_scale");
        feedback_scale = get_widget(GTK_WIDGET(data), "feedback_scale");

        adj = GTK_RANGE(delay_scale)->adjustment;
        gtk_adjustment_set_value(adj, 990.0);
	global_reverb_delay = 990;
        adj = GTK_RANGE(feedback_scale)->adjustment;
        gtk_adjustment_set_value(adj, 58.0);
	global_reverb_feedback = 58;
}



GtkWidget *init_effects_window()
{
	GtkWidget *effects_window;

	effects_window = create_effects_window();
#if 0
	GtkWidget *working;

	// Scale callbacks
	working = get_widget(effects_window, "delay_scale");
	gtk_signal_connect(GTK_OBJECT(working), "motion_notify_event",
		GTK_SIGNAL_FUNC(effects_scale_cb), &global_reverb_delay);
	working = get_widget(effects_window, "feedback_scale");
	gtk_signal_connect(GTK_OBJECT(working), "motion_notify_event",
		GTK_SIGNAL_FUNC(effects_scale_cb), &global_reverb_feedback);

	working = get_widget(effects_window, "preset1_button");
        gtk_signal_connect(GTK_OBJECT(working), "clicked",
                GTK_SIGNAL_FUNC(preset1_reverb), effects_window);
        working = get_widget(effects_window, "preset2_button");
        gtk_signal_connect(GTK_OBJECT(working), "clicked",
                GTK_SIGNAL_FUNC(preset2_reverb), effects_window);
        working = get_widget(effects_window, "preset3_button");
        gtk_signal_connect(GTK_OBJECT(working), "clicked",
                GTK_SIGNAL_FUNC(preset3_reverb), effects_window);
	working = get_widget(effects_window, "reverb_off");
        gtk_signal_connect(GTK_OBJECT(working), "clicked",
                GTK_SIGNAL_FUNC(reverb_off), effects_window);
#endif

	// Close/delete signals
	gtk_signal_connect(GTK_OBJECT(effects_window), "destroy",
                GTK_SIGNAL_FUNC(effects_delete_event), NULL);
	gtk_signal_connect(GTK_OBJECT(effects_window), "delete_event",
                GTK_SIGNAL_FUNC(effects_delete_event), NULL);
	return effects_window;
}
