/*
    Copyright (C) 2009 Fons Adriaensen <fons@kokkinizita.net>
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <string.h>
#include <math.h>
#include "ambisonic0.h"


void Ladspa_Tricard2amb::setport (unsigned long port, LADSPA_Data *data)
{
    _port [port] = data;
}


void Ladspa_Tricard2amb::active (bool act)
{
}


void Ladspa_Tricard2amb::runproc (unsigned long len, bool add)
{
    int   i;
    float lt, rt, bk;
    float *inp_L, *inp_R, *inp_B, *out_W, *out_X, *out_Y;

    inp_L = _port [INP_L];
    inp_R = _port [INP_R];
    inp_B = _port [INP_B];
    out_W = _port [OUT_W];
    out_X = _port [OUT_X];
    out_Y = _port [OUT_Y];
    memset (_port [OUT_Z], 0, len * sizeof (float));

    for (i = 0; i < (int)len; i++)
    {
	lt = inp_L [i];
	rt = inp_R [i];
	bk = inp_B [i];
	out_W [i] = 0.47140f * (lt + rt + bk);
	out_X [i] = 0.66667f * (lt + rt) - 1.33333f * bk;
	out_Y [i] = 1.15470f * (lt - rt);
    }
}



void Ladspa_Virtualmic::setport (unsigned long port, LADSPA_Data *data)
{
    _port [port] = data;
}


void Ladspa_Virtualmic::active (bool act)
{
}


void Ladspa_Virtualmic::runproc (unsigned long len, bool add)
{
    _vmic.set_elev (_port [CTL_ELEV][0]);
    _vmic.set_azim (_port [CTL_AZIM][0]);
    _vmic.set_angle (_port [CTL_ANGLE][0]);
    _vmic.set_direc (_port [CTL_POLAR][0]);
    _vmic.process (len,
                   _port [INP_W], _port [INP_X], _port [INP_Y], _port [INP_Z],
                   _port [OUT_L], _port [OUT_R]);
}



