// This is a -*- c++ -*- header file.

// Copyright (c) 1997 by Jim Lynch.
// This software comes with NO WARRANTY WHATSOEVER.
//
// This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; version 2 dated June, 1991, or, at your
//    option, any LATER version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program;  if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
//
// On Debian Linux systems, the complete text of the GNU General
// Public License can be found in `/usr/doc/copyright/GPL'.

#ifndef Record_h
#define Record_h

#include "db2++-stuff.h"

// #include <gdbm.h>
#include <malloc.h>
#include <string>
#include <iostream.h>

class Record
{
protected:
  virtual void Destroy(void)
    {
    }
  
  virtual void SetNull(void)
    {
    }

  virtual void SetFromDataString(const char *theDataString)
    {
    }
  
public:
  Record() { }
  
  virtual ~Record() { }
  
  virtual const char *FormNewDataCString() const
    {
    }

  virtual void Read(Db &handle, const string &theKey)
    {
      string theValue;
      
      Destroy();
      
      if(::Read(handle, theKey, theValue))
	{
	  SetFromDataString(theValue.c_str());
	}
      else
	{
	  SetNull();
	}

      // const char *key = theKey.c_str();
      //
      // Read(handle, key);
    }
  
  virtual void Read(Db &handle, const char *theKey)
    {
      string key(theKey);
      
      Read(handle, key);
      
      // Dbt key((void*) theKey, strlen(theKey) + 1);
      // Dbt content;
      // char * p;
      //
      // handle.get(NULL, &key, &content, 0);
      // p = (char *) content.get_data();
      //
      // Destroy();
      //
      // if(p)
      // {
      //   char *tmp = MakeCStringCopy(p);
      //
      //   SetFromDataString(tmp);
      // }
      // else
      //   SetNull();
    }
  
  virtual void Write(Db &handle, const char *theKey) const
    {
      string p(FormNewDataCString());
      string key(theKey);
      
      int wrOK = ::Write(handle, key, p);
    }

  virtual void Print(ostream &out) const
    {
      const char *p = FormNewDataCString();
      out << p;
      delete[] p;
    }
};

inline ostream &operator<<(ostream &out, const Record &it)
{
  it.Print(out);

  return out;
}

#endif

