/* Copyright (C) 2002, 2003, 2004 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#include <sstream>
#include "database.hpp"

using namespace std;

void Database::execScript( const std::string &script ) throw (Error)
{
  istringstream stream( script );
  execScript( stream );
}

void Database::execScript( istream &stream ) throw (Error)
{
  while ( !stream.eof() ) {
    string line;
    getline( stream, line );
    if ( line[ line.length() - 1 ] == ';' )
      execQuery( line.substr( 0, line.length() - 1 ) );
    else
      execQuery( line );
  };
}
