/* Copyright (C) 2002, 2003, 2004 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __RESULTROW_HPP
#define __RESULTROW_HPP

#include "include.hpp"
#include <boost/smart_ptr.hpp>
#include <string>
#include "error.hpp"
#include "object.hpp"

/** @addtogroup mysqlCpp
    @{ */
/** Class for accessing a single row of an SQL-query's result.
    @date Thu Mar 03 2005
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
class ResultRow: public Object
{
public:
  /// Empty constructor.
  ResultRow(void) {}
  /** Operator for retrieving columns.
      @param i Number of column (starting from <TT>0</TT>).
      @see Statement::getNumCols */
  virtual std::string operator[]( int i ) throw (Error) = 0;
  /** Invalidate the row.
      This method is called by the destructor of \c Statement to prevent
      the \c ResultRow object from using an invalid SQL-query handle. */
  virtual void invalidate(void) = 0;
};

///
typedef boost::shared_ptr< ResultRow > ResultRowPtr;

///@}

#endif
