/* callbacks.h - Prototypes for callbacks.c

   Copyright (C) 2000  Henning Kulander <hennikul@ifi.uio.no>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <gnome.h>


/* Global events: */
gboolean
on_delete_event                        (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data);

/* Menu selections: */
void
on_exit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_preferences1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data);

/* Buttons clicked: */
void
on_button_quit_clicked                 (GtkButton       *button,
                                        gpointer         user_data);

void
on_button_preferences_clicked          (GtkButton       *button,
                                        gpointer         user_data);

void
on_button_about_clicked                (GtkButton       *button,
                                        gpointer         user_data);

/* Property box: */

void
on_propertybox_apply                   (GnomePropertyBox *gnomepropertybox,
                                        gint             arg1,
                                        gpointer         user_data);

void
on_combo_entry_hostname_changed        (GtkEditable     *editable,
                                        gpointer         user_data);

void
on_spinbutton_delay_changed            (GtkEditable     *editable,
                                        gpointer         user_data);


void
on_radio_udp_toggled                   (GtkToggleButton *togglebutton,
                                        gpointer         user_data);

void
on_itemmenu1_add                       (GtkContainer    *container,
                                        GtkWidget       *widget,
                                        gpointer         user_data);

void
on_itemmenu2_add                       (GtkContainer    *container,
                                        GtkWidget       *widget,
                                        gpointer         user_data);

void
on_itemmenu3_add                       (GtkContainer    *container,
                                        GtkWidget       *widget,
                                        gpointer         user_data);

void
on_itemmenu4_add                       (GtkContainer    *container,
                                        GtkWidget       *widget,
                                        gpointer         user_data);

void
on_fontpicker_dials_font_set        (GnomeFontPicker *gnomefontpicker,
												    gpointer         arg1,
                                        gpointer         user_data);
