#!/usr/bin/perl
#======================================================================
# Copyright (c) 1999 Daniele Giacomini daniele@pluto.linux.it
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#======================================================================
# cerca.pl
#======================================================================

#----------------------------------------------------------------------
# Incorpora la libreria di decodifica dei dati.
#----------------------------------------------------------------------
require ('mini-lib.pl');

#======================================================================
# &Metodo_non_gestibile ()
#----------------------------------------------------------------------
sub Metodo_non_gestibile {
    print "Content-type: text/html\n";
    print "\n";
    print "<HTML>\n";
    print "<HEAD>\n";
    print "<TITLE>Errore</TITLE>\n";
    print "</HEAD>\n";
    print "<BODY>\n";
    print "<H1>Metodo $ENV{REQUEST_METHOD} non gestibile.</H1>\n";
    print "</BODY>\n";
    print "</HTML>\n";
};

#======================================================================
# &Modulo_iniziale ()
#----------------------------------------------------------------------
sub Modulo_iniziale {
    print "Content-type: text/html\n";
    print "\n";
    print "<HTML>\n";
    print "<HEAD>\n";
    print "<TITLE>Ricerca all'interno del sito</TITLE>\n";
    print "</HEAD>\n";
    print "<BODY>\n";
    print "<H1>Ricerca all'interno del sito</H1>\n";
    print "<P>\n";
    print "<FORM ACTION=\"/cgi-bin/cerca.pl\" METHOD=\"GET\">\n";
    print "<P>\n";
    print "Stringa di ricerca:\n";
    print "<INPUT NAME=\"richiesta\" SIZE=60>\n";
    print "<INPUT TYPE=submit VALUE=\"Cerca\"></P>\n";
    print "</FORM>\n";
    print "</BODY>\n";
    print "</HTML>\n";
};

#=======================================================================
# &Elabora_riga ()
#-----------------------------------------------------------------------
sub Elabora_riga {
    local( $riga ) = @_[0];
    local( $punteggio ) = 0;
    local( $file_percorso ) = "";
    local( $nome_file ) = "";
    local( $percorso ) = "";

    #-------------------------------------------------------------------
    # Scompone la riga in modo da estrarre il nome del file e il
    # percorso relativo al sito HTTP.
    #-------------------------------------------------------------------
    if ( $riga =~ m|^.*Score:\s+([0-9]*),.*?'(.*?)'.*$|i ) {
	$punteggio = $1;
	$file_percorso = $2;

	#---------------------------------------------------------------
	#  meglio scomporre l'analisi attraverso le espressioni
	# regolari, altrimenti si fa troppa confusione.
	#---------------------------------------------------------------
	$file_percorso =~ m|^(.*)\s+/home/httpd/html/(.*?)/?$|i;
	$nome_file = $1;
	$percorso = $2;

	#---------------------------------------------------------------
	# Se questa variabile  vuota, non si pu mettere la barra
	# iniziale.
	#---------------------------------------------------------------
	if ( $percorso eq "" ) {
	    ;
	} else {
	    $percorso = "/$percorso";
	}

	#---------------------------------------------------------------
	# Emette le righe utili come riferimenti ipertestuali.
	#---------------------------------------------------------------
	print "<P>Punteggio: $punteggio ";
	print "<A HREF=\"$percorso/$nome_file\">";
	print "$percorso/$nome_file</A></P>\n";
    }
}

#======================================================================
# &Elaborazione_richiesta ()
#----------------------------------------------------------------------
sub Elaborazione_richiesta {

    #------------------------------------------------------------------
    # Rinvia la richiesta a waissearch e ne restituisce l'esito.
    #------------------------------------------------------------------
    if ( open( WAIS, "echo -n | waissearch -d /var/lib/wais/http \'$DATI{richiesta}\' |" ) ) {

	print "Content-type: text/html\n";
	print "\n";
        print "<HTML>\n";
        print "<HEAD>\n";
	print "<TITLE>Risultato della ricerca in base al modello: ";
        print "$DATI{richiesta}</TITLE>\n";
	print "</HEAD>\n";
        print "<BODY>\n";
	print "<H1>Risultato della ricerca</H1>\n";
        print "<P><STRONG>$DATI{richiesta}</STRONG></p>\n";

        while ( $risposta = <WAIS> ) {
	    #-----------------------------------------------------------
	    # Legge le rige del testo restituito da waissearch, e
	    # se corrispondono al modello, la funzione seguente
	    # emette direttamente una riga adatta alla pagina che
	    # si sta costruendo.
	    #-----------------------------------------------------------
	    &Elabora_riga( $risposta );
	};

	print "</BODY>\n";
        print "</HTML>\n";

    } else {
	print "Content-type: text/html\n";
        print "\n";
	print "<HTML>\n";
        print "<HEAD>\n";
	print "<TITLE>Errore</TITLE>\n";
        print "</HEAD>\n";
	print "<BODY>\n";
        print "<H1>Errore</H1>\n";
	print "Si  manifestato un errore durante l'inoltro ";
        print "della richiesta.\n";
	print "</BODY>\n";
        print "</HTML>\n";
    }
}


#======================================================================
# Inizio del programma.
#======================================================================

local ( %DATI ) = ();
local ( $risposta ) = "";

#----------------------------------------------------------------------
# Decodifica i dati in funzione del tipo di metodo della richiesta.
#----------------------------------------------------------------------
if ( $ENV{REQUEST_METHOD} eq 'GET' ) {
    %DATI = &Decodifica_GET;
} elsif ( $ENV{REQUEST_METHOD} eq 'POST' ) {
    %DATI = &Decodifica_POST;
} else {
    &Metodo_non_gestibile;
};

#----------------------------------------------------------------------
# Controlla che sia stata indicata una stringa di ricerca, altrimenti
# mostra il modulo per iniziare.
#----------------------------------------------------------------------
if ( $DATI{richiesta} eq "" ) {
    &Modulo_iniziale();
} else {
    &Elaborazione_richiesta();
}

#======================================================================
1;
#======================================================================

