//=====================================================================
// java RicercaBinApp.java
//=====================================================================

import java.lang.*; // predefinita

//---------------------------------------------------------------------
class RicercaBinApp {

    //-----------------------------------------------------------------
    static int ricercabin(int[] lista, int x, int a, int z) {

	int m;

	//-------------------------------------------------------------
	// Determina l'elemento centrale.
	//-------------------------------------------------------------
	m = ( a + z ) / 2;

	if ( m < a ) {
	    //---------------------------------------------------------
	    // Non restano elementi da controllare: l'elemento cercato
	    // non c'.
	    //---------------------------------------------------------
	    return -1;

	} else if ( x < lista[m] ) {
	    //---------------------------------------------------------
	    // Si ripete la ricerca nella parte inferiore.
	    //---------------------------------------------------------
	    return ricercabin( lista, x, a, m-1 );

	} else if ( x > lista[m] ) {
	    //---------------------------------------------------------
	    // Si ripete la ricerca nella parte superiore.
	    //---------------------------------------------------------
	    return ricercabin( lista, x, m+1, z );

	} else {
	    //---------------------------------------------------------
	    // m rappresenta l'indice dell'elemento cercato.
	    //---------------------------------------------------------
	    return m;
	}
    }

    //=================================================================
    // Inizio del programma.
    //-----------------------------------------------------------------
    public static void main(String[] args) {

	int[] lista = new int[args.length-1];
	int x;
	int i;

	//-------------------------------------------------------------
	// Conversione degli argomenti della riga di comando in
	// numeri.
	//-------------------------------------------------------------
	x = Integer.valueOf(args[0]).intValue();

	for ( i = 1; i < args.length; i ++ ) {
	    lista[i-1] = Integer.valueOf(args[i]).intValue();
	}

	//-------------------------------------------------------------
	// Esegue la ricerca.
	// In Java, gli array sono oggetti, e come tali vengono passati
	// per riferimento.
	//-------------------------------------------------------------
	i = ricercabin( lista, x, 0, lista.length-1);

	//-------------------------------------------------------------
	// Visualizza il risultato.
	//-------------------------------------------------------------
	System.out.println( x + " si trova nella posizione " +
	    i + "." );
    }

}
//=====================================================================
