(* ================================================================= *)
(* RicercaBin.pas						     *)
(* Ricerca binaria.						     *)
(* ================================================================= *)
program RicercaBinaria;

const	DIM	= 100;

var	lista	: array[1..DIM] of integer;
	x	: integer;
	i	: integer;
	z	: integer;

(* ================================================================= *)
(* ricercabin( <x>, <ele-inf>, <ele-sup> )			     *)
(* ----------------------------------------------------------------- *)
function ricercabin( x : integer; a : integer; z : integer ) : integer;

var	m	: integer;

begin

    (* ------------------------------------------------------------- *)
    (* Determina l'elemento centrale.				     *)
    (* ------------------------------------------------------------- *)
    m := ( a + z ) / 2;
    
    if m < a then
	begin

	    (* ----------------------------------------------------- *)
	    (* Non restano elementi da controllare.		     *)
	    (* ----------------------------------------------------- *)
	    ricercabin := -1;
	end
    else if x < lista[m] then
	begin

	    (* ----------------------------------------------------- *)
	    (* Si ripete la ricerca nella parte inferiore.	     *)
	    (* ----------------------------------------------------- *)
	    ricercabin := ricercabin( x, a, m-1 );
	end
    else if x > lista[m] then
	begin

	    (* ----------------------------------------------------- *)
	    (* Si ripete la ricerca nella parte superiore.	     *)
	    (* ----------------------------------------------------- *)
	    ricercabin := ricercabin( x, m+1, z );
	end
    else
	begin

	    (* ----------------------------------------------------- *)
	    (* m rappresenta l'indice dell'elemento cercato.	     *)
	    (* ----------------------------------------------------- *)
	    ricercabin := m;
	end
    ;

end;

(* ================================================================= *)
(* Inizio del programma.					     *)
(* ----------------------------------------------------------------- *)
begin

    Writeln( 'Inserire la quantita'' di elementi.' );
    Writeln( DIM, ' al massimo.' );
    Readln( z );

    if z > DIM then
	begin
	    z := DIM;
	end
    ;

    Writeln( 'Inserire i valori dell''array' );

    for i := 1 to z do begin
	Write( 'elemento ', i:2, ': ' );
	Readln( lista[i] );
    end;

    Writeln( 'Inserire il valore da cercare' );
    Readln( x );
    
    i := ricercabin( x, 1, z );
    
    Writeln( 'Il valore cercato si trova nell''elemento', i );

end.

(* ================================================================= *)
