#!/usr/bin/perl
#======================================================================
# bsort.pl <valore>...
#======================================================================

#======================================================================
# &bsort ( <lista>, <inizio>, <fine> )
#----------------------------------------------------------------------
sub bsort {
    #------------------------------------------------------------------
    # Il primo argomento  un riferimento all'array, per cui
    # lo scalare $lista diventa il nuovo riferimento locale all'array.
    # Per leggerlo come array occorrer la forma @$lista, mentre
    # per leggerne un elemento occorrer la forma ${$lista}[n].
    #------------------------------------------------------------------
    local( $lista ) = @_[0];
    local( $a ) = @_[1];
    local( $z ) = @_[2];

    local( $scambio );

    local( $j );
    local( $k );

    #------------------------------------------------------------------
    # Inizia il ciclo di scansione dell'array.
    #------------------------------------------------------------------
    for ( $j = $a; $j < $z; $j++ ) {

        #--------------------------------------------------------------
        # Scansione interna dell'array per collocare nella posizione
        # $j l'elemento giusto.
        #--------------------------------------------------------------
        for ( $k = $j+1; $k <= $z; $k++ ) {

            if ( ${$lista}[$k] < ${$lista}[$j] ) {

                #------------------------------------------------------
                # Scambia i valori
                #------------------------------------------------------
                $scambio = ${$lista}[$k];
                ${$lista}[$k] = ${$lista}[$j];
                ${$lista}[$j] = $scambio;
            };
        };
    };
};

#======================================================================
# Inizio del programma.
#----------------------------------------------------------------------

@lista = @ARGV;

&bsort (\@lista, 0, $#lista);

print "@lista\n";

#======================================================================

