; ======================================================================
; hanoi1.scm 
; Torre di Hanoi.
; ======================================================================

; ======================================================================
; (hanoi <n-anelli> <piolo-iniziale> <piolo-finale>)
; ----------------------------------------------------------------------
(define (hanoi n p1 p2)
    (if (> n 0)
	(begin
	    (hanoi (- n 1) p1 (- 6 (+ p1 p2)))
	    (begin
		(display "Muovi l'anello ")
		(display n)
		(display " dal piolo ")
		(display p1)
		(display " ")
		(display p2)
		(newline)
	    )
	    (hanoi (- n 1) (- 6 (+ p1 p2)) p2)
	)
    )
)


; ======================================================================
; Inizio del programma.
; ----------------------------------------------------------------------
(define n 0)
(define p1 0)
(define p2 0)

(display "Inserisci il numero di pioli: ")
(set! n (read))
(newline)
(display "Inserisci il numero del piolo iniziale (da 1 a 3): ")
(set! p1 (read))
(newline)
(display "Inserisci il numero del piolo finale (da 1 a 3): ")
(set! p2 (read))
(newline)
(hanoi n p1 p2)

; ======================================================================
