#ifndef PKGIMPORT_H_
#define PKGIMPORT_H_

//! Reuses lots of processing code
#include "expiration.h"

#include "fileio.h"
#include <time.h>
#include <string.h>
#include "csmapping.h"


class pkgimport : public expiration {

public:
	
	pkgimport(int);
	
	void Action(const MYSTD::string & src);
	
protected:
	// FileHandler
	bool ProcessRegular(const MYSTD::string &sPath, const struct stat &);
	bool ProcessOther(const MYSTD::string &sPath, const struct stat &);
	void _HandlePkgEntry(const tRemoteFileInfo &entry);
	void _LoadKeyCache(const MYSTD::string & sFileName);

private:

	/*!
	 *  Two maps mapping in different directions:
		-	fingerprints pointing to file info description vector,
	 		created by file scan+identification
	 	-	when reusing old fingerprints, a file info description is mapped
	 		to stored fingerprint (cacheMap from expiration)
	*/
	tImportMap m_importMap;
	MYSTD::set<MYSTD::string> m_precachedList;
	/* tFprCacheMap m_cacheMap;*/
	

	bool m_bPickIfiles;
	MYSTD::string m_sSrcPath;
		
	bool LinkOrCopy(const MYSTD::string &from, const MYSTD::string &to);
	//void _ExtractLocationsFromVolFiles();
	void _GuessAndGetIfiles();
	
	//bool _StoreInCache(tImapIter);
		
};


#endif /*PKGIMPORT_H_*/
