// download_manager.cc
//
//  Just passes the calls along as signals.

#include "download_manager.h"

void download_manager::Fetched(unsigned long Size, unsigned long ResumePoint)
{
  pkgAcquireStatus::Fetched(Size, ResumePoint);

  Fetched_sig(Size, ResumePoint, *this);
}

bool download_manager::MediaChange(string Media, string Drive)
{
  return MediaChange_sig(Media, Drive, *this);
}

void download_manager::IMSHit(pkgAcquire::ItemDesc &item)
{
  IMSHit_sig(item, *this);
}

void download_manager::Fetch(pkgAcquire::ItemDesc &item)
{
  Fetch_sig(item, *this);
}

void download_manager::Done(pkgAcquire::ItemDesc &item)
{
  Done_sig(item, *this);
}

void download_manager::Fail(pkgAcquire::ItemDesc &item)
{
  Fail_sig(item, *this);
}

bool download_manager::Pulse(pkgAcquire *Owner)
{
  pkgAcquireStatus::Pulse(Owner);

  return Pulse_sig(Owner, *this);
}

void download_manager::Start()
{
  pkgAcquireStatus::Start();

  Start_sig(*this);
}

void download_manager::Stop()
{
  pkgAcquireStatus::Stop();

  Stop_sig(*this);
}

void download_manager::Complete()
{
  Complete_sig(*this);
}
