// edit_pkg_hier.h           -*-c++-*-
//
//  Copyright 2001 Daniel Burrows
//
// This provides a convenient way to tweak the package hierarchy.  It lets
// the user select which 'groups' a package appears in, then allows them to
// save the changes to a file.
//
// Changes to the hierarchy are stored in GLOBAL VARIABLES.  Specifically,
// the user_pkg_hier global variable.

#ifndef EDIT_PKG_HIER
#define EDIT_PKG_HIER

#include <generic/pkg_hier.h>

#include <apt-pkg/pkgcache.h>

#include <vscreen/vs_tree.h>

class vs_hier_editor:public vs_tree
{
  class vs_hier_item;

  // Ugh..track all the children we created..
  std::vector<vs_hier_item *> items;

  pkg_hier::item *item;

  // Used for the "lazily load package hierarchies" behavior -- if we
  // get a "set package" command and this widget is invisible, it gets
  // deferred until the widget is shown.  This connection is used to
  // avoid connecting this command more than once.
  SigC::Connection shown_conn;

  void save_hier(std::string file);

  void handle_reload();
protected:
  virtual bool handle_char(chtype ch);

  void paint();
public:
  bool get_cursorvisible();

  vs_hier_editor();

  void set_package(const pkgCache::PkgIterator &pkg);

  void set_package(const pkgCache::PkgIterator &pkg,
		   const pkgCache::VerIterator &ver);

  void set_package(std::string name);

  SigC::Signal0<void> commit_changes;
};

#endif
